package com.tykj.dev.device.user.subject.dao;

import com.tykj.dev.device.user.subject.entity.Units;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface UnitsDao extends JpaRepository<Units, Integer>, JpaSpecificationExecutor<Units> {
    List<Units> findAllByLevel(Integer level);

    List<Units> findAllByAreaId(Integer areaId);

    Units findByName(String unitName);

    List<Units> findAllByLevelGreaterThanEqual(Integer level);

    List<Units> findByAreaIdIn(List<Integer> areaIds);

  List<Units> findAllByAreaIdIn(List<Integer> ids);

  List<Units> findByAreaId(Integer area);

  List<Units> findByIdDel(Integer idDel);


}
