package com.tykj.dev.rfid.timeTask;

import cn.pda.serialport.Tools;
import com.module.interaction.ReaderHelper;
import com.rfid.RFIDReaderHelper;
import com.rfid.ReaderConnector;
import com.rfid.rxobserver.RXObserver;
import com.rfid.rxobserver.bean.RXInventoryTag;
import com.rfid.rxobserver.bean.RXOperationTag;
import com.util.StringTool;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Observer;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class Thread
 * @packageName com.tykj.dev.rfid.timeTask
 **/
@Slf4j
public class InventoryThread extends Thread{

    private final int ANT_COUNT = 1;

    private int currentAnt = 0;
    ArrayList<String> strEpcs = new ArrayList<>();
    ArrayList<String> strTids = new ArrayList<>();
    ReaderConnector mConnector = new ReaderConnector();
    Boolean runFlag = true;

    ReaderHelper mReaderHelper;

    Observer mObserver = new RXObserver() {
        @Override
        protected void onInventoryTag(RXInventoryTag tag) {
            //将EPC添加至List中
            if (!strEpcs.contains(tag.strEPC)){
                strEpcs.add(tag.strEPC);
            }

        }

        @Override
        protected void onInventoryTagEnd(RXInventoryTag.RXInventoryTagEnd endTag) {
            for (String x:
                    strEpcs) {
                //设置EPC编码
                byte[] bytes = StringTool.stringToByteArray(x);
                ((RFIDReaderHelper) mReaderHelper).setAccessEpcMatch((byte) 0x01, (byte) bytes.length, bytes);
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                //读取标签
                byte[] pass = Tools.HexString2Bytes("00000000");
                int i = ((RFIDReaderHelper) mReaderHelper).readTag((byte) 0xFF, (byte) 0x02, (byte) 0x00, (byte) 0x06, pass);
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("现存标签EPC数量："+strEpcs.size());
            System.out.println("现存标签TID数量："+strTids.size());
            //设置天线
            if (ANT_COUNT>1){
                currentAnt = ++currentAnt%ANT_COUNT;
                System.out.println("切换天线至："+currentAnt);
                ((RFIDReaderHelper) mReaderHelper).setWorkAntenna((byte) 0x01,(byte)currentAnt);
            }
            if (runFlag){
                ((RFIDReaderHelper) mReaderHelper).realTimeInventory((byte) 0xff, (byte) 0x01);
            }
        }

        @Override
        protected void onExeCMDStatus(byte cmd, byte status) {
            //盘存
            ((RFIDReaderHelper) mReaderHelper).realTimeInventory((byte) 0xff, (byte) 0x01);
        }

        @Override
        protected void onOperationTag(RXOperationTag tag) {
            String tid = tag.strData.replaceAll(" ","");
            if (!strTids.contains(tid)){
                strTids.add(tid);
            }
        }
    };

    @Override
    public void run() {
        mReaderHelper = mConnector.connectNet("192.168.0.178", 4001);
        if (mReaderHelper != null) {
            try {
                mReaderHelper.registerObserver(mObserver);
                ((RFIDReaderHelper) mReaderHelper).setWorkAntenna((byte) 0x01,(byte) 0x00);
                ((RFIDReaderHelper) mReaderHelper).realTimeInventory((byte) 0xff, (byte) 0x01);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        } else {
            log.error("连接天线失败");
            mConnector.disConnect();
        }
    }

    public void setRunFlag(Boolean runFlag) {
        this.runFlag = runFlag;
    }

    public ArrayList<String> getStrTids() {
        return strTids;
    }

    public ReaderHelper getmReaderHelper() {
        return mReaderHelper;
    }

    public ReaderConnector getmConnector() {
        return mConnector;
    }
}
