/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.DriverPrinterConnection;
import com.zebra.sdk.comm.MultichannelTcpConnection;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.comm.TcpStatusConnection;
import com.zebra.sdk.comm.UsbConnection;
import com.zebra.sdk.comm.internal.ConnectionBuilderInternal;
import com.zebra.sdk.remote.comm.MultichannelRemoteConnection;
import com.zebra.sdk.remote.comm.RemoteConnection;
import com.zebra.sdk.remote.comm.RemoteStatusConnection;

public class ConnectionBuilder {
    private ConnectionBuilder() {
    }

    private static void initializeClasses() {
        ConnectionBuilder.addConnectionType(MultichannelTcpConnection.class);
        ConnectionBuilder.addConnectionType(TcpConnection.class);
        ConnectionBuilder.addConnectionType(TcpStatusConnection.class);
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            ConnectionBuilder.addConnectionType(DriverPrinterConnection.class);
        }
        ConnectionBuilder.addConnectionType(UsbConnection.class);
        ConnectionBuilder.addConnectionType(MultichannelRemoteConnection.class);
        ConnectionBuilder.addConnectionType(RemoteConnection.class);
        ConnectionBuilder.addConnectionType(RemoteStatusConnection.class);
    }

    public static void addConnectionType(Class<? extends Connection> clazz) {
        ConnectionBuilderInternal.addConnectionType(clazz);
    }

    public static Connection build(String string) throws ConnectionException {
        return ConnectionBuilderInternal.build(string);
    }
}

