/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.internal;

public class Option {
    private String title;
    private String longTitle;
    private String arg;
    private String description;
    private boolean argRequired;
    private boolean hidden;

    public Option(String string, String string2) {
        this(string, null, string2);
    }

    public Option(String string, String string2, String string3) {
        this.title = string;
        this.description = string3;
        this.longTitle = string2;
        this.argRequired = false;
        this.hidden = false;
    }

    public Option addArg(String string, boolean bl) {
        this.arg = string;
        this.argRequired = bl;
        return this;
    }

    public Option setHidden(boolean bl) {
        this.hidden = bl;
        return this;
    }

    public Option setLongTitle(String string) {
        this.longTitle = string;
        return this;
    }

    public boolean matches(String string) {
        return this.title.equalsIgnoreCase(string) || this.longTitle.equalsIgnoreCase(string);
    }

    public Option setDescription(String string) {
        this.description = string;
        return this;
    }

    public boolean argRequired() {
        return this.argRequired;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.longTitle != null) {
            stringBuilder.append(String.format("-%s/--%s ", this.title, this.longTitle));
        } else {
            stringBuilder.append(String.format("-%s ", this.title));
        }
        if (this.arg != null) {
            stringBuilder.append(String.format("<%s>", this.arg));
        }
        stringBuilder.append(String.format(" - %s", this.description));
        return stringBuilder.toString();
    }

    public String getArgName() {
        return this.arg;
    }

    public boolean hasArg() {
        return this.arg != null;
    }

    public String getLongName() {
        return this.longTitle;
    }

    public String getName() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }
}

