/*
 * Decompiled with CFR 0.152.
 */
package com.rfid;

import com.module.interaction.ModuleConnector;
import com.module.interaction.ReaderHelper;
import com.rfid.RFIDReaderHelper;
import com.rfid.ReaderDataPackageParser;
import com.rfid.ReaderDataPackageProcess;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ReaderConnector
implements ModuleConnector {
    private final String HOSTNAME_REGEXP = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
    private RFIDReaderHelper mRFIDReaderHelper;
    private Socket mSocket;
    private InetSocketAddress mRemoteAddr;
    private SerialPort mSeialPort = null;
    private final String USER = "USER";

    @Override
    public ReaderHelper connectCom(String port, int baud) {
        block3: {
            try {
                CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)port);
                this.mSeialPort = (SerialPort)portIdentifier.open("USER", 5000);
                this.mSeialPort.setSerialPortParams(baud, 8, 1, 0);
                if (this.mSeialPort != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.connect(this.mSeialPort.getInputStream(), this.mSeialPort.getOutputStream());
    }

    @Override
    public ReaderHelper connectNet(String host, int port) {
        if (!host.matches("^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$")) {
            return null;
        }
        try {
            this.mRemoteAddr = new InetSocketAddress(host, port);
            this.mSocket = new Socket();
        }
        catch (Exception e1) {
            return null;
        }
        try {
            this.mSocket.connect(this.mRemoteAddr, 4000);
            return this.connect(this.mSocket.getInputStream(), this.mSocket.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ReaderHelper connect(InputStream in, OutputStream out) {
        this.mRFIDReaderHelper = new RFIDReaderHelper();
        try {
            this.mRFIDReaderHelper.setReader(in, out, new ReaderDataPackageParser(), new ReaderDataPackageProcess());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.mRFIDReaderHelper;
    }

    @Override
    public boolean isConnected() {
        return this.mRFIDReaderHelper != null ? this.mRFIDReaderHelper.isAlive() : false;
    }

    @Override
    public void disConnect() {
        if (this.mRFIDReaderHelper != null) {
            this.mRFIDReaderHelper.signOut();
            this.mRFIDReaderHelper = null;
        }
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
                this.mSocket = null;
            }
            if (this.mSeialPort != null) {
                this.mSeialPort.close();
                this.mSeialPort = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mRemoteAddr = null;
    }
}

