package com.oscar.util;

%%

/* public class */
%public

/* yylex() return Word object */
%type Word 

%ignorecase

/* support Chinese */
%unicode

LINE_TERMINATOR = \r|\n|\r\n
WHITE_SPACE_CHAR={LINE_TERMINATOR}|[ \t\f]
STRING_TEXT_DOUBLE=(\\\"|[^\"])*
STRING_TEXT_SINGLE=(\'|[^'])*
CHAR=[^\n\r \t\f;()]
IDENTIFIER = ({CHAR})+

%%
/* keywords */
<YYINITIAL> "explain"          { return new Word(Word.EXPLAIN, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "create"           { return new Word(Word.CREATE, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "select"           { return new Word(Word.SELECT, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "into"             { return new Word(Word.INTO, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "update"           { return new Word(Word.UPDATE, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "set"              { return new Word(Word.SET, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "insert"           { return new Word(Word.INSERT, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "delete"           { return new Word(Word.DELETE, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "drop"             { return new Word(Word.DROP, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "from"             { return new Word(Word.FROM, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "as"               { return new Word(Word.AS, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "prepare"          { return new Word(Word.PREPARE, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "grant"            { return new Word(Word.GRANT, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "revoke"           { return new Word(Word.REVOKE, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "declare"          { return new Word(Word.DECLARE, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "avg"              { return new Word(Word.AVG, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "count"            { return new Word(Word.COUNT, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "max"              { return new Word(Word.MAX, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "min"              { return new Word(Word.MIN, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "stddev"           { return new Word(Word.STDDEV, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "sum"              { return new Word(Word.SUM, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "variance"         { return new Word(Word.VARIANCE, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "("                { return new Word(Word.LPAREN, yytext(), yychar, yychar+yylength());}
<YYINITIAL> ")"                { return new Word(Word.RPAREN, yytext(), yychar, yychar+yylength());}
<YYINITIAL> ";"                { return new Word(Word.SEMI, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "audit"            { return new Word(Word.AUDIT, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "noaudit"          { return new Word(Word.AUDIT, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "rollback"         { return new Word(Word.ROLLBACK, yytext(), yychar, yychar+yylength());}
<YYINITIAL> "begin"            { return new Word(Word.BEGIN, yytext(), yychar, yychar+yylength());}

<YYINITIAL> "group by"            { return new Word(Word.GROUP_BY, yytext(), yychar, yychar+yylength());}


<YYINITIAL> {
  /* double quoted string */ 
  \"{STRING_TEXT_DOUBLE}\" 	 { 
    String str =  yytext().substring(1, yylength()-1);
    return (new Word(Word.STRING_DOUBLE, str, yychar,yychar+yylength()));  
  }
  
  /* single quoted string */ 
  '{STRING_TEXT_SINGLE}' 	 { 
    String str =  yytext().substring(1,yylength()-1);
    return (new Word(Word.STRING_SINGLE, str, yychar, yychar+yylength()));    
  }
  
  /* identifiers */ 
  {IDENTIFIER}                   { 
    return new Word(Word.STRING_IDENTIFIER,yytext(),yychar,yychar+yylength());
  }
  
  /* whitespace */
  {WHITE_SPACE_CHAR}             { /* ignore */ }
}

<<EOF>>                          { return new Word(Word.EOF, "EOF"); }