package com.tykj.dev.device.allot.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.allot.subject.vo.AllotBillSaveVo;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.misc.base.ResultObj;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/batchAllot")
@AutoDocument
@Api(tags = "装备配发模块", description = "装备配发接口")
@Slf4j
public class BatchAllotController {

    @Autowired
    private AllotBillController allotBillController;

    @Autowired
    private TaskService taskService;

    @ApiOperation(value = "发起批量配发(type 1:签字配发，2:签章配发)")
    @PostMapping(value = "/createBatchAllot/{type}/{userId}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity createBatchAllot(@PathVariable("type") int type, @PathVariable("userId") int userId ,@RequestBody List<AllotBillSaveVo> allotBillSaveVoList){
//        List<Integer> billIds = new ArrayList<>();
        Map<String, Integer> map = new HashMap<>();//存放的key  接受单位  value billId
        if (type==1){
//            allotBillSaveVoList.forEach(allotBillSaveVo ->
//                    allotBillController.addAllotBill(allotBillSaveVo)
//            );
            for (AllotBillSaveVo allotBillSaveVo : allotBillSaveVoList) {
                ResponseEntity responseEntity = allotBillController.addAllotBill(allotBillSaveVo);
                ResultObj resultObj = (ResultObj)responseEntity.getBody();
                AllotBill allotBill = (AllotBill)resultObj.getData();
                String receiveUnit = allotBillSaveVo.getReceiveUnit();
                Integer billId = allotBill.getId();
                map.put(receiveUnit,billId);
            }
        }
        else {
            //任务id
            List<String> taskIds = new ArrayList<>();
            //批量保存草稿
//            allotBillSaveVoList.forEach(allotBillSaveVo -> {
//                String s = (String)allotBillController.saveAllotBill(allotBillSaveVo).getBody();
//                taskIds.add(Integer.valueOf(s.substring(4)));
//            });
            for (AllotBillSaveVo allotBillSaveVo : allotBillSaveVoList) {
                String s = (String)allotBillController.saveAllotBill(allotBillSaveVo).getBody();
                String newS = s.substring(4);
                String receiveUnit = allotBillSaveVo.getReceiveUnit();
                String taskId = newS+","+receiveUnit;
                taskIds.add(taskId);
            }
            //批量申请签章
//            taskIds.forEach(integer -> allotBillController.applySign(integer,userId));
            for (String taskId : taskIds) {
                String[] strings = taskId.split(",");
                //取出来taskId
                String realStringTaskId = strings[0];
                //取出来接受单位
                String receiveUnit = strings[1];
                Integer realTaskId = Integer.valueOf(realStringTaskId);
                allotBillController.applySign(realTaskId,userId);
                Integer billId = taskService.get(realTaskId).getBillId();
                map.put(receiveUnit,billId);
            }
        }
        return ResponseEntity.ok(map);
    }
}
