package com.tykj.dev.device.allot.service;

import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.allot.subject.vo.AllotBillSelectVo;
import com.tykj.dev.device.file.entity.FileRet;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
public interface AllotBillService {

    /**
     * 新增配发单
     */
    AllotBill addEntity(AllotBill allotBillEntity);

    /**
     * @param allotBills 异步上链
     */
    void sendHash(List<AllotBill> allotBills);

    /**
     * 更新账单
     */
    AllotBill update(AllotBill allotBillEntity);

    /**
     * @param allotBillSelectVo 查询vo
     * @param pageable 分页
     * @return 配发单分页
     */
    Page<AllotBill> getPage(AllotBillSelectVo allotBillSelectVo, Pageable pageable);

    /**
     * @param allotBillSelectVo 查询vo
     * @return 配发单集合
     */
    List<AllotBill> getList(AllotBillSelectVo allotBillSelectVo);

    /**
     * @param id 账单id
     * 根据id获取配发单
     */
    AllotBill getOne(Integer id);

    /**
     * @param id 账单id
     * 根据id删除配发单
     */
    void delete(Integer id);

//    /**
//     * @param
//     *  *在配发存储的时候用到存储数据库
//     */
//    void updateAllot();

    /**
     * 根据任务id查询单据
     * @param taskId
     * @return
     */
    Map<String,List<FileRet>> getFileList(Integer taskId);
}
