package com.tykj.dev.device.apply.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.apply.service.DeviceApplyBillService;
import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.apply.subject.vo.*;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.library.subject.vo.Script;
import com.tykj.dev.device.packing.controller.PackingController;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.task.repository.TaskDao;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.vo.TaskLogUserVo;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.bto.MessageBto;
import com.tykj.dev.device.user.subject.dao.UserDao;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.ResultObj;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.*;
import com.tykj.dev.rfid.service.InputOutputDeviceService;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.groupingBy;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "装备申请模块", description = "申请模块")
@AutoDocument
@RequestMapping("/apply")
@Slf4j
@Validated
public class DeviceApplyController {

    @Autowired
    private DeviceApplyBillService deviceApplyBillService;

    @Autowired
    private UserUtils userUtils;

    @Autowired
    private TaskService taskService;

    @Autowired
    private DeviceLogService deviceLogService;

    @Autowired
    private UserPublicService userPublicService;

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private TaskLogService taskLogService;

    @Autowired
    private PackingLibraryService packingLibraryService;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private TaskDao taskDao;

    @Autowired
    private MyWebSocket myWebSocket;

    @Autowired
    private Snowflake snowflake;

    @Autowired
    private InputOutputDeviceService inputOutputDeviceService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private UserDao userDao;

    @Autowired
    private PackingController packingController;

    @Autowired
    private DeviceLibraryDao deviceLibraryDao;

    @ApiOperation(value = "发起装备申请", notes = "可以通过这个接口发起装备申请")
    @PostMapping("/addDeviceApplyBill")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity addDeviceApplyBill(@RequestBody @Validated DeviceApplySaveVo deviceApplySaveVo) {
        //不是装备申请
        if (deviceApplySaveVo.getApplyType()!=1) {
            for (ApplyBillDetailVo applyBillDetailVo : GetTreeUtils.splitTree2(deviceApplySaveVo.getStorageBillDetailVoList(),ApplyBillDetailVo::getChilds)) {
                //判断该装备是否存在装备库
                ResponseEntity responseEntity = packingController.seqsExist(applyBillDetailVo.getPackingId(), applyBillDetailVo.getStorageCount(), applyBillDetailVo.getSeqInterval());
                if (!"ok".equals(responseEntity.getBody())) {
                    return responseEntity;
                }
            }
        }
        //添加申请单
        DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.addEntity(deviceApplySaveVo.toDo());
        Integer userId = userUtils.getCurrentUserId();
        //发起任务
        TaskBto taskBto;
        String title;
        switch (deviceApplySaveVo.getApplyType()){
            case 2:
                title = "退役申请";
                break;
            case 3:
                title = "报废申请";
                break;
            case 4:
                title = "销毁申请";
                break;
            default:
                title = "装备申请";
        }
        if (userUtils.getCurrentUnitLevel()==1){
            //如果是省  等待中办 设置状态为3
            deviceApplyBillEntity.setApplyStatus(3);
            deviceApplyBillService.update(deviceApplyBillEntity);
            List<Integer> userIds = new ArrayList<>();
            userIds.add(userId);
            userIds.add(0);
            taskBto = new TaskBto(StatusEnum.WAIT_APPLY_FILE.id, title, null, ".", deviceApplyBillEntity.getId(), 9,userUtils.getCurrentUnitId(), 1, "country", userIds);
            taskBto.setRemark(title);
        }
        else {
            //指定批复人
            if (deviceApplySaveVo.getReplyUseraId() != null) {
                List<Integer> userIds = new ArrayList<>();
                userIds.add(userId);
                userIds.add(deviceApplySaveVo.getReplyUseraId());
                //DEVICE_APPLY_CONFIRM  装备申请待批复
                taskBto = new TaskBto(StatusEnum.DEVICE_APPLY_CONFIRM.id, title, null, ".", deviceApplyBillEntity.getId(), 9, userPublicService.findUnitIdByName(deviceApplySaveVo.getReplyUnit()), 1, null, userIds);
            }
            //不指定批复人
            else {
                List<Integer> userIds = new ArrayList<>();
                userIds.add(userId);
                userIds.add(0);
                taskBto = new TaskBto(StatusEnum.DEVICE_APPLY_CONFIRM.id, title, null, ".", deviceApplyBillEntity.getId(), 9, userPublicService.findUnitIdByName(deviceApplySaveVo.getReplyUnit()), 1, null, userIds);
            }
        }
        TaskBto taskBto1 = taskService.start(taskBto);
        //发送阅知信息
        List<Integer> userIds = userPublicService.findOtherUser(userId);
        if (userUtils.getCurrentUnitLevel()!=1) {
            userIds.addAll(userDao.findAllByUnitsId(userPublicService.findUnitIdByName(deviceApplyBillEntity.getReplyUnit())).stream()
                    .map(User::getUserId)
                    .collect(Collectors.toList()));
        }
        String message;
        switch (deviceApplySaveVo.getApplyType()){
            case 2:
                message = "发起退役申请";
                break;
            case 3:
                message = "发起报废申请";
                break;
            case 4:
                message = "发起销毁申请";
                break;
            default:
                message = "发起装备申请";
        }
        MessageBto messageBto = new MessageBto(taskBto1.getId(),taskBto1.getBusinessType(),message,userIds);
        messageService.add(messageBto);
        log.info("[申请模块]:"+message);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok("ok");
    }

    @ApiOperation(value = "装备申请批复", notes = "可以通过这个接口批复")
    @PostMapping("/replay")//不用了
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity addDeviceApplyBillReplay(@RequestBody @Validated DeviceApplyConfirmVo deviceApplyConfirmVo) {
        TaskBto taskBto = taskService.get(deviceApplyConfirmVo.getTaskId());
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.DEVICE_APPLY_CONFIRM);
        Integer userId = userUtils.getCurrentUserId();
        taskService.addInvolveUser(taskBto, userId);
        DeviceApplyBill applyBillEntity = deviceApplyBillService.getOne(taskBto.getBillId());
        applyBillEntity.setReplyUseraId(userId);
        //阅知用户Id
        List<Integer> ids = userPublicService.findOtherUser(userId);
        ids.addAll(userDao.findAllByUnitsId(userPublicService.findUnitIdByName(applyBillEntity.getApplyUnit())).stream()
                .map(User::getUserId)
                .collect(Collectors.toList()));
        //如果修改了批复文号
        if (deviceApplyConfirmVo.getReplyNumber() != null) {
            applyBillEntity.setReplayNumber(deviceApplyConfirmVo.getReplyNumber());
        }
        //批复驳回
        if (deviceApplyConfirmVo.getStatus() == 1) {
            applyBillEntity.setApplyStatus(1);
            taskService.update(taskService.moveToArchive(taskBto));
            deviceApplyBillService.update(applyBillEntity);
            //发送阅知信息
            MessageBto messageBto = new MessageBto(taskBto.getId(),taskBto.getBusinessType(),"对" + userPublicService.getAreaNameByUnitName(applyBillEntity.getApplyUnit()) + "的装备申请驳回",ids);
            messageService.add(messageBto);
            log.info("[申请模块]:装备申请驳回");
            myWebSocket.sendMessage1();
            return ResponseEntity.ok(taskBto);
        }
        //批复成功
        if (deviceApplyConfirmVo.getStatus() == 0) {
            applyBillEntity.setApplyStatus(2);
            taskService.update(taskService.moveToEnd(taskBto));
            //发送阅知信息
            MessageBto messageBto = new MessageBto(taskBto.getId(),taskBto.getBusinessType(),"同意" + userPublicService.getAreaNameByUnitName(applyBillEntity.getApplyUnit()) + "的装备申请",ids);
            messageService.add(messageBto);
            log.info("[申请模块]:装备申请批复成功，发起配发子业务");
            //生成配发子任务
            List<Integer> userIds = new ArrayList<>();
            userIds.add(0);
            TaskBto taskBto1 = new TaskBto(StatusEnum.WAIT_ALLOT.id, "配发业务", taskBto.getId(), "." + taskBto.getId() + ".", 0, 3, userUtils.getCurrentUnitId(), 0, null, userIds);
            TaskBto task = taskService.start(taskBto1);
            deviceApplyBillService.update(applyBillEntity);
            myWebSocket.sendMessage1();
            return ResponseEntity.ok(task);
        } else {
            throw new ApiException(ResultUtil.failed("status只能为0或1"));
        }
    }

    @ApiOperation(value = "装备申请后发起配发", notes = "可以通过这个接口装备申请后发起配发")
    @PostMapping("/allot")//不用了
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity allot(@RequestBody @Validated DeviceApplyAllotSaveVo deviceApplyAllotSaveVo) {
        //判断装备状态是否在库或待退役（若不是抛出303异常）
        deviceLibraryService.isInStockOrWaitRetired(StringSplitUtil.split(deviceApplyAllotSaveVo.getAllotCheckDetail()));
        //获取配发的业务
        TaskBto taskBto = taskService.get(deviceApplyAllotSaveVo.getTaskId());
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.WAIT_ALLOT);
        //获取申请的业务
        TaskBto applyTask = taskService.get(taskBto.getParentTaskId());
        Integer userId = userUtils.getCurrentUserId();
        taskService.addInvolveUser(taskBto,userId);
        //获取申请账单
        DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.getOne(applyTask.getBillId());
        //添加配发单  配发单中的配发类型  就是申请单中的申请类型吗
        AllotBill allotBillEntity = new AllotBill();
        BeanUtils.copyProperties(deviceApplyAllotSaveVo, allotBillEntity);
        allotBillEntity.setTitle("申请后配发");
        allotBillEntity.setSendUseraId(userId);
//        allotBillEntity.setReceiveUseraId(applyTask.getCreateUserId());
        allotBillEntity.setApplyNumber(deviceApplyBillEntity.getApplyNumber());
        allotBillEntity.setReplayNumber(deviceApplyBillEntity.getReplayNumber());
        allotBillEntity.setApplyFiles(deviceApplyBillEntity.getApplyNumFiles());
        allotBillEntity.setReplyFiles(deviceApplyBillEntity.getReplyFiles());
        allotBillEntity.setSendUnit(deviceApplyBillEntity.getReplyUnit());
        allotBillEntity.setReceiveUnit(deviceApplyBillEntity.getApplyUnit());
        allotBillEntity.setSendTime(new Date());
        allotBillEntity.setAllotType(2);//?????
        allotBillEntity.setAllotStatus(2); //配发中
        //判断单据是否为空
        if(deviceApplyAllotSaveVo.getScriptSaveVos()!=null) {
            allotBillEntity.setScriptJson(JacksonUtil.toJSon(deviceApplyAllotSaveVo.getScriptSaveVos()));
        }
        //判断接收人发送人是否为空号
        if (deviceApplyAllotSaveVo.getSendUserbId()!=null) {
            allotBillEntity.setAgent(userPublicService.getOne(deviceApplyAllotSaveVo.getSendUserbId()).getName());
        }
        AllotBill allotBill = allotBillService.addEntity(allotBillEntity);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(allotBill.getCreateTime());
        int year = calendar.get(Calendar.YEAR);
        String num = "NO:第" + year + "PF" + allotBill.getId() + "号";
        allotBill.setNum(num);
        deviceApplyBillEntity.setAllotId(allotBill.getId());
        deviceApplyBillService.update(deviceApplyBillEntity);
        //生成电子签章id
//        Long signId = snowflake.creatNextId();
        Long signId2 = snowflake.creatNextId();
        //左签单
        if (deviceApplyAllotSaveVo.getLeftSignatureId()!=null) {
            allotBill.setLeftSignatureId(deviceApplyAllotSaveVo.getLeftSignatureId());
        }
        allotBill.setRightSignatureId(signId2.toString());
        AllotBill allotBill1 = allotBillService.update(allotBill);
        taskBto.setBillId(allotBill.getId());
        //配发业务移动到下一阶段  配发中
        TaskBto taskBto1 = taskService.moveToSpecial(taskBto,StatusEnum.ALLOTING);
        taskBto1.setOwnUnit(userPublicService.findUnitIdByName(allotBill.getReceiveUnit()));
        Task saveEntity = taskService.update(taskBto1);
        List<Integer> userIds2 = new ArrayList<>();
        userIds2.add(userId);
        userIds2.add(0);
        TaskBto taskBto2 = new TaskBto(StatusEnum.WAIT_UPLOAD_ALLOT_FILE.id, "配发单据", saveEntity.getId(), saveEntity.getNodeIdDetail()+saveEntity.getId()+".", saveEntity.getBillId(), 3, userPublicService.findUnitIdByName(allotBillEntity.getSendUnit()), 0, null, userIds2);
        taskService.start(taskBto2);
        //添加业务日志
        List<FileVo> fileVoList = new ArrayList<>();
//        fileVoList.add(new FileVo("出库确认单", allotBillEntity.getFileName(), allotBillEntity.getFileUrl()));
        //添加装备日志
        List<Integer> integerList = StringSplitUtil.split(allotBillEntity.getAllotCheckDetail());
        List<Integer> ids = new ArrayList<>();
        if (integerList.size() > 0) {
            for (Integer id : integerList) {
                if (id > 0) {
                    ids.add(id);
                    //改变装备状态
                    DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(id);
                    deviceLibraryEntity.setLifeStatus(3);//配发状态
                    deviceLibraryEntity.setManageStatus(0);//不在属于单位
                    DeviceLogDto deviceLogDto = new DeviceLogDto(id, "对" + allotBillEntity.getReceiveUnit() + "发起配发", fileVoList,taskBto.getId(),null);
                    deviceLogService.addLog(deviceLogDto);
                }
            }
        }
        //添加出库白名单 0 是入  1是出
        inputOutputDeviceService.addWhiteDevices(ids, userUtils.getCurrentUnitId(), 1);
        //发送阅知信息
        List<Integer> userIds = userPublicService.findOtherUser(userId);
        userIds.addAll(userDao.findAllByUnitsId(userPublicService.findUnitIdByName(allotBillEntity.getReceiveUnit())).stream()
                .map(User::getUserId)
                .collect(Collectors.toList()));
        if (deviceApplyAllotSaveVo.getSendUserbId()!=null) {
            List<Integer> idList1 = new ArrayList<>();
            idList1.add(deviceApplyAllotSaveVo.getSendUserbId());
            MessageBto messageBto = new MessageBto(taskBto1.getId(), taskBto1.getBusinessType(), "被选为签发人", idList1, 1);
            messageService.add(messageBto);
        }
        MessageBto messageBto = new MessageBto(taskBto1.getId(),taskBto1.getBusinessType(),"对" + userPublicService.getAreaNameByUnitName(allotBillEntity.getReceiveUnit()) + "发起配发",userIds,1);
        messageService.add(messageBto);
        log.info("[申请模块]:装备申请后发起配发");
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(new ResultObj(allotBill1, "发起成功"));
    }

    @ApiOperation(value = "查询申请任务详情", notes = "可以通过这个接口查询申请任务详情")
    @GetMapping(value = "/detail/{billId}")
    public ResponseEntity selectDetail(@PathVariable("billId") int billId) {
        ApplyDetailVo applyDetailVo = new ApplyDetailVo();
        //获取业务
        TaskBto taskBto = taskService.get(billId, BusinessEnum.APPLY.id);
        //获取账单
        DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.getOne(billId);
        if (deviceApplyBillEntity.getApplyUseraId() != null) {
            deviceApplyBillEntity.setApplyUser(userPublicService.getOne(deviceApplyBillEntity.getApplyUseraId()).getName());
        }
        applyDetailVo.setDeviceApplyBill(deviceApplyBillEntity);
        //获取申请的列装Id和数量
        List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
        List<Integer> packingIdList = new ArrayList<>();
        List<Integer> numList = new ArrayList<>();
        List<PackingLibrary> packingLibraryEntityList = new ArrayList<>();
        if (idList.size() > 0) {
            //奇数存列装id，偶数存数量
            for (int i = 1; i <= idList.size(); i++) {
                if (i % 2 == 1) {
                    packingIdList.add(idList.get(i - 1));
                } else {
                    numList.add(idList.get(i - 1));
                }
            }
        }
        if (packingIdList.size() == numList.size()) {
            //set申请数量
            for (int i = 0; i < packingIdList.size(); i++) {
                PackingLibrary p = packingLibraryService.getOne(packingIdList.get(i));
                p.setApplyNum(numList.get(i));
                packingLibraryEntityList.add(p);
            }
        }
        applyDetailVo.setPackingLibraries(packingLibraryEntityList);
        //获取可配发装备,按列装Id筛选,列装Id排序
        applyDetailVo.setDeviceLibraries(deviceLibraryService.getAllotList(new DeviceLibrarySelectVo()).stream()
                .filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId()))
                .sorted(Comparator.comparing(DeviceLibrary::getPackingId,Comparator.nullsLast(Integer::compareTo)))
                .collect(Collectors.toList()));
        //添加业务日志
        List<TaskLogUserVo> applyLogUserVos = taskLogService.getByTaskId(taskBto.getId());
        //查询子任务
        List<Task> sonTasks = taskDao.findAllByParentTaskId(taskBto.getId());
        //添加子任务日志
        if (sonTasks.size() > 0) {
            sonTasks.forEach(task -> applyLogUserVos.addAll(taskLogService.getByTaskId(task.getId())));
        }
        //按日志时间排序
        List<TaskLogUserVo> allLogUserVos = applyLogUserVos.stream()
                .sorted(Comparator.comparing(TaskLogUserVo::getCreateTime,Comparator.nullsLast(Date::compareTo)))
                .collect(Collectors.toList());
        applyDetailVo.setTaskLogUserVos(allLogUserVos);
        return ResponseEntity.ok(applyDetailVo);
    }

    @ApiOperation(value = "批复上传回执单", notes = "批复上传回执单")
    @PostMapping("/uploadFile")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity uploadFile(@RequestBody @Validated UploadApplyFile uploadApplyFile) {
        TaskBto taskBto = taskService.get(uploadApplyFile.getTaskId());
        taskService.addInvolveUser(taskBto, userUtils.getCurrentUserId());
        //不同意
        if (uploadApplyFile.getStatus()==0){
            taskService.moveToEnd(taskBto);
            List<Integer> userIds = userPublicService.findOtherUser(userUtils.getCurrentUserId());
            MessageBto messageBto = new MessageBto(taskBto.getId(),taskBto.getBusinessType(),"申请不同意，业务办结",userIds,0);
            messageService.add(messageBto);
            DeviceApplyBill deviceApplyBill = deviceApplyBillService.getOne(taskBto.getBillId());
            deviceApplyBill.setApplyStatus(1);
            deviceApplyBill.setBackFiles(FilesUtil.stringFileToList(uploadApplyFile.getBackFiles()));
            if (uploadApplyFile.getReplyVos() != null && uploadApplyFile.getReplyVos().size() > 0) {
                deviceApplyBill.setReplyVos(JacksonUtil.toJSon(uploadApplyFile.getReplyVos()));
            }
            if (uploadApplyFile.getReplayNumber() != null) {
                deviceApplyBill.setReplayNumber(uploadApplyFile.getReplayNumber());
            }
            if (uploadApplyFile.getReplyFiles() != null && uploadApplyFile.getReplyFiles().size() > 0) {
                deviceApplyBill.setReplyFiles(FilesUtil.stringFileToList(uploadApplyFile.getReplyFiles()));
            }
            //add
            deviceApplyBill.setAgent(uploadApplyFile.getAgent());
            deviceApplyBill.setReplyUnit(uploadApplyFile.getReplyUnit());
            deviceApplyBillService.update(deviceApplyBill);
        }
        else {
            if (uploadApplyFile.getReplyVos() != null && uploadApplyFile.getReplyVos().size() > 0) {
                for (ReplyVo replyVo : uploadApplyFile.getReplyVos()) {
                    ResponseEntity responseEntity = packingController.seqsExist(replyVo.getId(), replyVo.getNum(), replyVo.getSeqInterval());
                    if (!"ok".equals(responseEntity.getBody())) {
                        return responseEntity;
                    }
                }
            }
            if (uploadApplyFile.getApplyBillDetailVos() != null && uploadApplyFile.getApplyBillDetailVos().size() > 0) {
                for (ApplyBillDetailVo a : uploadApplyFile.getApplyBillDetailVos()) {
//                    ResponseEntity responseEntity = packingController.seqsNotExist(a.getPackingId(), a.getStorageCount(), a.getSeqInterval());
                    ResponseEntity responseEntity = packingController.seqsNotExist(a.getPackingId(), a.getWaitNum(), a.getSeqInterval());
                    if (!"ok".equals(responseEntity.getBody())) {
                        return responseEntity;
                    }
                }
            }
            taskService.moveToNext(taskBto);
            DeviceApplyBill deviceApplyBill = deviceApplyBillService.getOne(taskBto.getBillId());
            deviceApplyBill.setApplyStatus(4);
            deviceApplyBill.setBackFiles(FilesUtil.stringFileToList(uploadApplyFile.getBackFiles()));
            if (uploadApplyFile.getReplyVos() != null && uploadApplyFile.getReplyVos().size() > 0) {
                deviceApplyBill.setReplyVos(JacksonUtil.toJSon(uploadApplyFile.getReplyVos()));
            }
            if (uploadApplyFile.getReplayNumber() != null) {
                deviceApplyBill.setReplayNumber(uploadApplyFile.getReplayNumber());
            }
            if (uploadApplyFile.getReplyFiles() != null && uploadApplyFile.getReplyFiles().size() > 0) {
                deviceApplyBill.setReplyFiles(FilesUtil.stringFileToList(uploadApplyFile.getReplyFiles()));
            }
            if (uploadApplyFile.getApplyBillDetailVos() != null && uploadApplyFile.getApplyBillDetailVos().size() > 0) {
                deviceApplyBill.setApplyStat(JacksonUtil.toJSon(uploadApplyFile.getApplyBillDetailVos()));
            }
            //add
            deviceApplyBill.setAgent(uploadApplyFile.getAgent());
            deviceApplyBill.setReplyUnit(uploadApplyFile.getReplyUnit());
            DeviceApplyBill deviceApplyBill1 = deviceApplyBillService.update(deviceApplyBill);
            //通过列装id查询列装
//            List<ApplyBillDetailVo> applyBillDetailVos = uploadApplyFile.getApplyBillDetailVos();
//            for (ApplyBillDetailVo applyBillDetailVo : applyBillDetailVos) {
//                PackingLibrary packingLibrary = packingLibraryService.getOne(applyBillDetailVo.getPackingId());
//                BeanUtils.copyProperties(applyBillDetailVo,packingLibrary);
//                packingLibraryService.update(packingLibrary);
//            }
            if (deviceApplyBill.getApplyType() > 1) {
                List<String> seqs = new ArrayList<>();
                List<ReplyVo> replyVos = JacksonUtil.readValue(deviceApplyBill1.getReplyVos(), new TypeReference<List<ReplyVo>>() {
                });
                if (replyVos != null) {
                    for (ReplyVo r : replyVos) {
                        seqs.addAll(DeviceSeqUtil.selectDeviceSeqs(r.getSeqInterval()));
                    }
                }
                deviceLibraryDao.upDateSeqNumbersApplyTaskId(taskBto.getId(), seqs);
            }
        }
        return ResponseEntity.ok("ok");
    }

    @ApiOperation(value = "确认接收申请装备", notes = "确认接收申请装备")
    @PostMapping("/confirm/{id}")//不用了
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity confirm(@PathVariable("id") int taskId) {
        TaskBto taskBto = taskService.get(taskId);
        taskService.addInvolveUser(taskBto,userUtils.getCurrentUserId());
        taskService.moveToEnd(taskBto);
        DeviceApplyBill deviceApplyBill = deviceApplyBillService.getOne(taskBto.getBillId());
        deviceApplyBill.setApplyStatus(2);
        deviceApplyBillService.update(deviceApplyBill);
        return ResponseEntity.ok("确认成功");
    }

    @ApiOperation(value = "判断申请业务是否清退完成", notes = "判断申请业务是否清退完成")
    @GetMapping("/sendBackOver/{id}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity sendBackOver(@PathVariable("id") int taskId) {
        TaskBto taskBto = taskService.get(taskId);
        DeviceApplyBill deviceApplyBill = deviceApplyBillService.getOne(taskBto.getBillId());
        List<ReplyVo> replyVos = Objects.requireNonNull(JacksonUtil.readValue(deviceApplyBill.getReplyVos(), new TypeReference<List<ReplyVo>>() {
        }));
        List<String> seqs= new ArrayList<>();
        for (ReplyVo replyVo : replyVos){
            seqs.addAll(DeviceSeqUtil.selectDeviceSeqs(replyVo.getSeqInterval()));
        }
        List<DeviceLibrary> deviceLibraries = deviceLibraryService.findAllBySeqNumber(seqs);
        Set<Integer> lifeStatus = deviceLibraries.stream().map(DeviceLibrary::getLifeStatus).collect(Collectors.toSet());
        Set<Integer> integers = new HashSet<>();
        integers.add(11);
        final Integer status;
        if (deviceApplyBill.getApplyType()==2) {
            integers.add(15);
            integers.add(12);
            integers.add(16);
            status=15;
        }
        else if(deviceApplyBill.getApplyType()==3){
            integers.add(17);
            integers.add(5);
            integers.add(18);
            status=17;
        }
        else if (deviceApplyBill.getApplyType()==4){
            integers.add(19);
            integers.add(10);
            integers.add(20);
            status=19;
        }
        else {
            throw new ApiException("申请类型只能为2，3，4");
        }
        if (integers.containsAll(lifeStatus)){
            List<Script> scripts = new ArrayList<>();
            List<DeviceLibrary> deviceLibraryList1 = deviceLibraries.stream().filter(deviceLibrary -> deviceLibrary.getLifeStatus().equals(status)).collect(Collectors.toList());
            Map<Integer, List<DeviceLibrary>> map = deviceLibraryList1.stream().collect(groupingBy(DeviceLibrary::getPackingId));
            for (Integer packingId:map.keySet()){
                List<DeviceLibrary> deviceLibraryList = map.get(packingId);
                PackingLibrary packingLibrary = packingLibraryService.getOne(packingId);
                Script script = new Script();
                script.setId(packingId);
                script.setPartParentId(packingLibrary.getPartParentId());
                script.setInvisibleRange(packingLibrary.getInvisibleRangeName());
                script.setModel(packingLibrary.getModel());
                script.setName(packingLibrary.getName());
                script.setSecretLevel(packingLibrary.getSecretLevelName());
                script.setType(packingLibrary.getTypeName());
                script.setNum(deviceLibraryList.size());
                script.setSeqNumber(StringSplitUtil.stringListToString(DeviceSeqUtil.getContinuousSeqs(deviceLibraryList.stream().map(DeviceLibrary::getSeqNumber).collect(Collectors.toList()))));
                scripts.add(script);
            }
            Map<Integer, Script> nodeCollect =
                    scripts.stream().collect(Collectors.toMap(Script::getId, script -> script));
            List<Script> scriptList = new ArrayList<>();
            List<Script> conList = GetTreeUtils.parseTreeFromDown(
                    scripts,
                    Script::getId,
                    script -> Optional.ofNullable(nodeCollect.get(script.getPartParentId())),
                    Script::addChildNode
            );
            for (Script s:conList) {
                addScript(scriptList,s);
            }
            return ResponseEntity.ok(scriptList);
        }
        else {
            return ResponseEntity.ok(false);
        }
    }

    private void addScript(List<Script> scripts,Script script){
        scripts.add(script);
        if (script.getChilds()!=null&&script.getChilds().size()>0){
            script.getChilds().forEach(s -> addScript(scripts,s));
        }
    }

    @ApiOperation(value = "手动办结申请任务", notes = "手动办结申请任务")
    @PostMapping("/over/{id}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity over(@PathVariable("id") int taskId) {
        TaskBto taskBto = taskService.get(taskId);
        taskService.addInvolveUser(taskBto,userUtils.getCurrentUserId());
        taskService.moveToEnd(taskBto);
        DeviceApplyBill deviceApplyBill = deviceApplyBillService.getOne(taskBto.getBillId());
        deviceApplyBill.setApplyStatus(2);
        deviceApplyBillService.update(deviceApplyBill);
        //发送阅知信息
        MessageBto messageBto = new MessageBto();
        messageBto.setContent("业务办结");
        messageBto.setTaskId(taskBto.getId());
        messageBto.setIsHighLight(0);
        messageBto.setInvolveUserIdList(userPublicService.findOtherUser(userUtils.getCurrentUserId()));
        messageBto.setBusinessType(taskBto.getBusinessType());
        messageService.add(messageBto);
        return ResponseEntity.ok("办结成功");
    }
}
