package com.tykj.dev.config;

import com.tykj.dev.misc.base.*;
import lombok.Data;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
@Slf4j
public class GlobalMap {

    public static final Map<Integer, StatusEnum> statusEnumMap;

    private static final Map<Integer, RepairStatusEnum> repairStatusMap;

    private static final Map<Integer, LogType> logTypeMap;

    private static final Map<Integer, DeviceLifeStatus> deviceLifeStatusMap;

    private static final Map<Integer, MatchingRange> matchingRangeMap;

    private static final Map<Integer, StorageType> storageTypeMap;

    private static final Map<Integer, MatchingDeviceType> matchingDeviceTypeMap;

    private static final Map<Integer, DeviceInvisibleRange> deviceInvisibleRangeMap;

    private static final Map<Integer,DeviceSecretLevel> deviceSecretLevelMap;

    private static final Map<Integer,String> businessMap;

    static {
        statusEnumMap = Arrays.stream(StatusEnum.values())
                .collect(Collectors.toMap(statusEnum -> statusEnum.id, Function.identity()));
        repairStatusMap = Arrays.stream(RepairStatusEnum.values())
                .collect(Collectors.toMap(repairStatusEnum -> repairStatusEnum.id, Function.identity()));
        logTypeMap = Arrays.stream(LogType.values())
                .collect(Collectors.toMap(logType -> logType.id, Function.identity()));
        deviceLifeStatusMap = Arrays.stream(DeviceLifeStatus.values())
                .collect(Collectors.toMap(deviceLifeStatus -> deviceLifeStatus.id, Function.identity()));
        matchingRangeMap = Arrays.stream(MatchingRange.values())
                .collect(Collectors.toMap(matchingRange -> matchingRange.id, Function.identity()));
        storageTypeMap = Arrays.stream(StorageType.values())
                .collect(Collectors.toMap(storageType -> storageType.id, Function.identity()));
        matchingDeviceTypeMap = Arrays.stream(MatchingDeviceType.values())
                .collect(Collectors.toMap(matchingDeviceType -> matchingDeviceType.id, Function.identity()));
        deviceInvisibleRangeMap = Arrays.stream(DeviceInvisibleRange.values())
                .collect(Collectors.toMap(deviceInvisibleRange -> deviceInvisibleRange.id, Function.identity()));
        deviceSecretLevelMap = Arrays.stream(DeviceSecretLevel.values())
                .collect(Collectors.toMap(deviceSecretLevel -> deviceSecretLevel.id, Function.identity()));
        businessMap = Arrays.stream(BusinessEnum.values())
                .collect(Collectors.toMap(businessEnum -> businessEnum.id, businessEnum -> businessEnum.name));
        log.info("[初始化] 初始map结束...");
    }

    public static Map<Integer, StatusEnum> getStatusEnumMap() {
        return statusEnumMap;
    }

    public static Map<Integer, RepairStatusEnum> getRepairStatusMap() {
        return repairStatusMap;
    }

    public static Map<Integer, LogType> getLogTypeMap() {
        return logTypeMap;
    }

    public static Map<Integer, DeviceLifeStatus> getDeviceLifeStatusMap() {
        return deviceLifeStatusMap;
    }

    public static Map<Integer, MatchingRange> getMatchingRangeMap() {
        return matchingRangeMap;
    }

    public static Map<Integer, StorageType> getStorageTypeMap() {
        return storageTypeMap;
    }

    public static Map<Integer, MatchingDeviceType> getMatchingDeviceTypeMap() {
        return matchingDeviceTypeMap;
    }

    public static Map<Integer, DeviceInvisibleRange> getDeviceInvisibleRangeMap() {
        return deviceInvisibleRangeMap;
    }

    public static Map<Integer, DeviceSecretLevel> getDeviceSecretLevelMap() {
        return deviceSecretLevelMap;
    }

    public static Map<Integer, String> getBusinessMap() {
        return businessMap;
    }
}
