package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 配套设备类型枚举
 */

@AllArgsConstructor
public enum MatchingType {
    /**
     * 打印机
     */
    PRINTER(1, "打印机"),
    /**
     * 手持设备
     */
    HANDHELD_DEVICES(2, "手持设备");

    public Integer id;

    public String name;


    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("配套设备类型");
        systemConfig.setEnglishName("matchingType");
        return systemConfig;
    }
}
