package com.tykj.dev.config.domin;

import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Entity;
import javax.persistence.EntityListeners;

/**
 * 系统配置表实体类
 * @author dengdiyi
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update system_config set delete_tag = 1 where id = ?")
@ApiModel("系统配置表")
public class SystemConfig extends BaseEntity {

    @ApiModelProperty(value = "英文变量名")
    private String englishName;

    @ApiModelProperty(value = "中文变量名")
    private String chineseName;

    @ApiModelProperty(value = "变量值")
    private Integer value;

    @ApiModelProperty(value = "变量值显示名")
    private String label;
}
