package com.tykj.dev.config.task;

import com.tykj.dev.config.domin.SystemVariable;
import com.tykj.dev.config.repository.SystemVariableDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SystemVariableRun implements CommandLineRunner {

    @Autowired
    private SystemVariableDao systemVariableDao;

    @Override
    public void run(String... args) throws Exception {
        if(systemVariableDao.findByName("selfCheckCycle")==null) {
            SystemVariable systemVariable = new SystemVariable();
            systemVariable.setName("selfCheckCycle");
            systemVariable.setVaule("0 0 0 1 1/3 ? ");
            systemVariableDao.save(systemVariable);
            log.info("系统变量selfCheckCycle新建成功");
        } else if (systemVariableDao.findByName("selfCheckCycle").getVaule().length()<14) {
            SystemVariable systemVariable = systemVariableDao.findByName("selfCheckCycle");
            systemVariable.setVaule("0 0 0 1 1/3 ? ");
            systemVariableDao.save(systemVariable);
            log.info("系统变量selfCheckCycle新建成功");
        } else {
            log.info("已有系统变量selfCheckCycle不新建");
        }
        if(systemVariableDao.findByName("warningInterval")==null){
            SystemVariable systemVariable2 = new SystemVariable();
            systemVariable2.setName("warningInterval");
            systemVariable2.setVaule("10000");
            systemVariableDao.save(systemVariable2);
            log.info("系统变量warningInterval新建成功");
        }
        else {
            log.info("已有系统变量warningInterval不新建");
        }
    }
}
