package com.tykj.dev.device.confirmcheck.entity.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * CheckExamVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/1/12 at 3:56 下午
 */
@Data
@ApiModel("检查发起对象")
public class CheckExamVo {

    @ApiModelProperty(name = "业务标题", example = "浙江省手动核查测试")
    private String title;

    @ApiModelProperty(name = "截止时间", example = "2021-01-12")
    private LocalDate endTime ;

    @ApiModelProperty(name = "发起单位的id号")
    private Integer unitId;

    @ApiModelProperty(name = "检查统计业务id,如果是直接创建则给0",example = "0")
    private Integer examStatId;

    @ApiModelProperty(name = "发起检查细节")
    @JSONField(name = "detail")
    private List<CheckExamDetailVo> detail;
}
