package com.tykj.dev.device.decommissioning.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.decommissioning.entity.vo.DecommissioningSelectVo;
import com.tykj.dev.device.decommissioning.entity.vo.RepelManagementVo;
import com.tykj.dev.device.decommissioning.service.DeviceDecommissioningQueryService;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryController.java
 * @Description TODO
 * @createTime 2021年01月10日 15:43:00
 */
@RestController
@Api(tags = "装备退役查询接口模块", description = "包括装备清退、装备异常处理、装备出库、装备入库")
@AutoDocument
@RequestMapping("/decommissioningQuery")
public class DecommissioningQueryController {

    @Autowired
    DeviceDecommissioningQueryService deviceDecommissioningQueryService;

    @Autowired
    DeviceLibraryService deviceLibraryService;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;

    @Autowired
    PackingLibraryService packingLibraryService;

    /**
     * 查询退役中办任务
     */
    @ApiOperation(value = "查询退役中办任务")
    @GetMapping("/outsideTheProvince")
    public ResponseEntity findOutsideTheProvince() {
        return ResponseEntity.ok(deviceDecommissioningQueryService.findOutsideTheProvince());
    }


    /**
     * 查询已办结退役任务列表
     */
    @ApiOperation(value = "查询退役中办任务")
    @GetMapping("/endProvince")
    public ResponseEntity findOutsideTheProvinceEnd() {
        return ResponseEntity.ok(deviceDecommissioningQueryService.findOutsideTheProvinceEnd());
    }


    /**
     * 待清退 待退役
     */
    @PostMapping(value ="/toBeRetiredDeviceList")
    @ApiOperation(value = "待清退", notes = "待清退列表")
    public ResponseEntity clearedList1(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(deviceDecommissioningQueryService.toBeRetiredDeviceList(repelManagementVo));
    }


    /**
     * 退役中
     */
    @PostMapping(value ="/findRetired")
    @ApiOperation(value = "退役中", notes = "退役中列表")
    public ResponseEntity clearedList2(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(deviceDecommissioningQueryService.findRetired(repelManagementVo));
    }


    /**
     * 已退役
     */
    @PostMapping(value ="/retiredDeviceList")
    @ApiOperation(value = "已退役", notes = "已清退列表")
    public ResponseEntity clearedList4(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(deviceDecommissioningQueryService.retiredDeviceList(repelManagementVo));
    }


    /**
     * 根据taskId查询业务详情
     */
    @GetMapping(value ="/detail/{taskId}")
    @ApiOperation(value = "根据taskId查询业务详情", notes = "根据taskId查询业务详情")
    public ResponseEntity findDetail(@PathVariable Integer taskId){
        return ResponseEntity.ok(deviceDecommissioningQueryService.findTaskIdDeviceDecommissioningDetail(taskId));
    }

    /**
     * 根据ApplyId查询退役任务
     */
    @GetMapping(value ="/findApplyIdToDecommissioningTask/{applyId}")
    @ApiOperation(value = "根据taskId查询业务详情", notes = "根据taskId查询业务详情")
    public ResponseEntity findApplyIdToDecommissioningTask(@PathVariable Integer applyId){
        return ResponseEntity.ok(deviceDecommissioningQueryService.findApplyIdToDecommissioningTask(applyId));
    }


    /**
     * 业务办理档案接口
     */
    @PostMapping(value ="/findPageDeviceDecommissioningDetail")
    @ApiOperation(value = "业务办理档案接口", notes = "业务办理档案接口调用")
    public ResponseEntity findApplyIdToDecommissioningTask(@RequestBody DecommissioningSelectVo decommissioningSelectVo){
        return ResponseEntity.ok(deviceDecommissioningQueryService.findPageDeviceDecommissioningDetail(decommissioningSelectVo));
    }

    /**
     * 业务办理档案接口
     */
    @GetMapping(value ="/test")
    @ApiOperation(value = "test", notes = "业务办理档案接口调用")
    public ResponseEntity responseEntity(){
        List<String> list=new ArrayList<>();
        list.add("129678376353");
        deviceLibraryService.judgeSeqNumbersInNotEqualLifeStatus(list,3);
        return ResponseEntity.ok("ok");
    }

    @GetMapping(value ="/repel/fileMap/{taskId}")
    @ApiOperation(value = "根据任务ID查询业务相关单据", notes = "根据任务ID查询业务相关单据")
    public ResponseEntity repelFileMap( @PathVariable Integer taskId){
        return ResponseEntity.ok(deviceDecommissioningQueryService.findByTaskIdToFileMapList(taskId));
    }
}
