package com.tykj.dev.device.decommissioning.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.file.entity.Documents;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description DeviceRepel 清退业务id
 * @createTime 2021年01月06日 20:02:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("退役详情")
public class DeviceDecommissioningDetail extends BaseEntity {

    /**
     * 标题
     */
    @ApiModelProperty(value = "单据编号")
    private String title;

    /**
     * 申请id
     */
    private Integer applyId;

    /**
     * 编号
     */
    @ApiModelProperty(value = "单据编号")
    private String num;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    /**
     * 发件单位
     */
    @ApiModelProperty(value = "发件单位")
    private String sendUnit;

    /**
     * 发件单位id
     */
    @ApiModelProperty(value = "发件单位id")
    private Integer sendUnitId;

    /**
     * 收件单位id
     */
    @ApiModelProperty(value = "收件单位id")
    private Integer receiveUnitId;
    /**
     * 收件单位
     */
    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;
    /**
     * 配发时间
     */
    @ApiModelProperty(value = "配发时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;
    /**
     * 接收时间
     */
    @ApiModelProperty(value = "接收时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;
    /**
     * 经办人
     */
    @ApiModelProperty(value = "发件方id(A岗位)")
    private Integer sendUseraId;

    /**
     * 经办人 名称
     */
    @ApiModelProperty(value = "发件方名称(A岗位)")
    private String senderUserA;

    /**
     * 签发人
     */
    @ApiModelProperty(value = "签发人(B岗位)")
    private String senderUserB;

    /**
     * 签发人
     */
    @ApiModelProperty(value = "签发人(B岗位)")
    private Integer sendUserbId;
    /**
     * 收件方 经办人
     */
    @ApiModelProperty(value = "收件方id(A岗位)")
    private Integer receiveUseraId;

    /**
     * 收件方 经办人名称
     */
    @ApiModelProperty(value = "收件方名称(A岗位)")
    private String receiveUserA;

    /**
     * 收件方id(B岗位)
     */
    @ApiModelProperty(value = "收件方名称(B岗位)")
    private String receiveUserB;
    /**
     * 收件方id(B岗位)
     */
    @ApiModelProperty(value = "收件方id(B岗位)")
    private Integer receiveUserbId;

    /**
     * 出库附件文件
     */
    @ApiModelProperty(value = "出库附件文件")
    @Column(name = "outbound_file",columnDefinition = "TEXT")
    private String outboundFile;

    /**
     * 清退单文件
     */
    @ApiModelProperty(value = "清退单文件")
    @Column(name = "bill_file",columnDefinition = "TEXT")
    private String billFile;

    /**
     * 退役状态
     */
    @ApiModelProperty(value = "退役状态")
    private Integer decommissioningStatus;

    /**
     * 入库确认单
     */
    @ApiModelProperty
    @Column(name = "in_file",columnDefinition = "TEXT")
    private String inFile;

    @ApiModelProperty(value = "装备id集合")
    @Column(name = "device_ids",columnDefinition = "TEXT")
    private String deviceIds;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    /**
     * 提交描述
     */
    @ApiModelProperty(value = "提交描述")
    @Column(name = "submit_description",columnDefinition = "TEXT")
    private String submitDescription;
    /**
     * 审核反馈
     */
    @ApiModelProperty(value = "审核反馈")
    @Column(name = "auditing_feedback",columnDefinition = "TEXT")
    private String auditingFeedback;


    @ApiModelProperty(value = "批复文号文件")
    @Column(name = "reply_files",columnDefinition = "TEXT")
    private String replyFiles;

    @ApiModelProperty(value = "申请文号文件")
    @Column(name = "apply_files",columnDefinition = "TEXT")
    private String applyFiles;

    @Column(name = "send_files",columnDefinition = "TEXT")
    private String sendFiles;

    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @Transient
    private List<ScriptSaveVo> scripts = new ArrayList<>();



    @Transient
    private List<FileRet> sendFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "批复文号文件集合")
    private List<FileRet> replyFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "申请文号文件集合")
    private List<FileRet> applyFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "装备List")
    private List<DeviceLibrary> deviceLibraryEntities =new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "清退单对象")
    private List<FileRet> billFiles ;

    @Transient
    @ApiModelProperty(value = "清退单对象")
    private List<FileRet> inFiles ;

    @Transient
    @ApiModelProperty(value = "清退单对象")
    private List<FileRet> outboundFiles ;

    @Transient
    @ApiModelProperty(value = "任务id")
    private Integer taskId ;

    public Documents toDoc(){
        return new Documents(num,"装备清退单据",receiveUnit,replayNumber,sendUnit,null,null,senderUserA,senderUserB,receiveUserA,receiveUserB,null);
    }

}
