package com.tykj.dev.device.decommissioning.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.decommissioning.entity.DeviceDecommissioningDetail;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName OrderOutData.java
 * @Description TODO
 * @createTime 2021年01月10日 09:43:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DecommissioningOrderOutData {
    /**
     * 申请文号
     */
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;
    /**
     * 批复文号
     */
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    /**
     * 发件单位
     */
    @ApiModelProperty(value = "发件单位")
    private String sendUnit;

    /**
     * 发件单位id
     */
    @ApiModelProperty(value = "发件单位id")
    private Integer sendUnitId;

    /**
     * 收件单位id
     */
    @ApiModelProperty(value = "收件单位id")
    private Integer receiveUnitId;

    /**
     * 收件单位
     */
    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;
    /**
     * 配发时间
     */
    @ApiModelProperty(value = "配发时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime=new Date();

    /**
     * 经办人
     */
    @ApiModelProperty(value = "发件方id(A岗位)")
    private Integer sendUseraId;

    /**
     * 经办人 名称
     */
    @ApiModelProperty(value = "发件方名称(A岗位)")
    private String senderUserA;

    /**
     * 签发人
     */
    @ApiModelProperty(value = "签发人(B岗位)")
    private String senderUserB;

    /**
     * 签发人
     */
    @ApiModelProperty(value = "签发人(B岗位)")
    private Integer sendUserbId;
    /**
     * 收件方 经办人
     */
    @ApiModelProperty(value = "收件方id(A岗位)")
    private Integer receiveUseraId;

    /**
     * 收件方 经办人名称
     */
    @ApiModelProperty(value = "收件方名称(A岗位)")
    private String receiveUserA;

    /**
     * 收件方id(B岗位)
     */
    @ApiModelProperty(value = "收件方名称(B岗位)")
    private String receiveUserB;
    /**
     * 收件方id(B岗位)
     */
    @ApiModelProperty(value = "收件方id(B岗位)")
    private Integer receiveUserbId;

    /**
     * 出库附件文件
     */
    @ApiModelProperty(value = "出库附件文件")
    private String outboundFile;
    /**
     * 清退单文件
     */
    @ApiModelProperty(value = "清退单文件")
    private String billFile;

    /**
     * 装备id集合
     */
    @ApiModelProperty(value = "涉及装备的id集合")
    private List<Integer> devIds;

    /**
     * 出库附件文件
     */
    @ApiModelProperty(value = "出库附件文件")
    private List<FileRet> outboundFileList;
    /**
     * 清退单文件
     */
    @ApiModelProperty(value = "清退单文件")
    private List<FileRet> billFileList;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "批复文号文件集合")
    private List<FileRet> replyFileList = new ArrayList<>();

    @ApiModelProperty(value = "申请文号文件集合")
    private List<FileRet> applyFileList = new ArrayList<>();

    private List<FileRet> sendFileList = new ArrayList<>();

    @ApiModelProperty(value = "单据装备数据信息")
    private List<ScriptSaveVo> scriptSaveVos = new ArrayList<>();

    @ApiModelProperty(value = "任务Id")
    private Integer taskId;
    /**
     * 申请id
     */
    @ApiModelProperty(value = "申请id")
    private Integer applyId;

    public DeviceDecommissioningDetail toDeviceDecommissioningDetail() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, DeviceDecommissioningDetail.class);
    }

}
