package com.tykj.dev.device.decommissioning.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelManagementVo.java
 * @Description 清退管理 清退清退vo
 * @createTime 2021年01月23日 12:42:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("退役业务分页查询业务")
public class DecommissioningSelectVo extends CustomPage {
    @ApiModelProperty(name = "开始清退的年份 默认各式 2020-01-01 00：00：00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;

    @ApiModelProperty(name = "开始清退的年份 默认各式 2020-01-01 00：00：00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;

}
