package com.tykj.dev.device.destroy.entity.domain;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for device_destroy_bill
 * 装备销毁账单
 *
 * @author zjm
 */
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_destroy_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备销毁账单")
public class DeviceDestroyBill extends BaseEntity {

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "申请id")
    private Integer applyId;

    @ApiModelProperty(value = "单据编号")
    private String num;

    @ApiModelProperty(value = "单位Id")
    private Integer unitId;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "监销人")
    private String supervisor;

    @ApiModelProperty(value = "主管领导")
    private String leader;

    @ApiModelProperty(value = "承办人")
    private String undertaker;

    @ApiModelProperty(value = "经办人")
    private String agent;

    @ApiModelProperty(value = "销毁日期")
    private Date destroyTime;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @ApiModelProperty(value = "销毁状态")
    private Integer destroyStatus;

    @ApiModelProperty(value = "单据数据")
    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @ApiModelProperty(value = "申请文件数据")
    @Column(name = "apply_files",columnDefinition = "TEXT")
    private String applyFiles;

    @ApiModelProperty(value = "批复文件数据")
    @Column(name = "replay_files",columnDefinition = "TEXT")
    private String replayFiles;

    @ApiModelProperty(value = "销毁文件数据")
    @Column(name = "destruction_files",columnDefinition = "TEXT")
    private String destructionFiles;

    @Transient
    @ApiModelProperty(value = "单据数据集合")
    private List<ScriptSaveVo> scripts = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "申请文件集合")
    private List<FileRet> applyFileList;

    @ApiModelProperty(value = "批复文件集合")
    @Transient
    private List<FileRet> replayFileList;

    @Transient
    @ApiModelProperty(value = "装备List")
    private List<DeviceLibrary> deviceLibraryEntities =new ArrayList<>();

    @ApiModelProperty(value = "销毁文件集合")
    @Transient
    private List<FileRet> destructionFileList;

    @Transient
    private String unitName;

}
