package com.tykj.dev.device.destroy.repository;

import com.tykj.dev.device.destroy.entity.domain.DeviceDestroyBill;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @author dengdiyi
 */
public interface DeviceDestroyBillDao extends JpaRepository<DeviceDestroyBill, Integer>, JpaSpecificationExecutor<DeviceDestroyBill> {
    Optional<DeviceDestroyBill> findByApplyId(Integer applyId);

    @Query("select o from DeviceDestroyBill o where o.unitId= :unitId and o.createTime >= :startTime and o.createTime <= :endTime")
    List<DeviceDestroyBill> findAllByUnitBetweenTime(Integer unitId, Date startTime, Date endTime);

}
