package com.tykj.dev.device.file.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DocumentDevice.java
 * @Description 单据涉及装备实体
 * @createTime 2021年01月25日 10:19:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "单据涉及装备实体", description = "单据涉及装备实体")
public class DocumentDevice {

    @ApiModelProperty(value = "序号")
    private Integer code;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "部件")
    private String parts;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "类型")
    private String category;

    @ApiModelProperty(value = "密级")
    private String securityClassification;

    @ApiModelProperty(value = "应用领域")
    private String applicationField;

    @ApiModelProperty(value = "数量")
    private Integer count;

    @ApiModelProperty(value = "装备序列号")
    private String deviceSerialNumber;

    @ApiModelProperty(value = "生产序列号")
    private String productionSerialNumber;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "校对")
    private String proofreading;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty
    private String store;

    @ApiModelProperty
    private String ownUnit;

    private Integer oneCount;

    @ApiModelProperty(value = "配用范围")
    private String matchingRangeName;

    @ApiModelProperty(value = "设备类型 装备、配件")
    private Integer isPart;

    public Integer getLen(){
        return deviceSerialNumber.length();
    }

    public DocumentDevice toOneCount(){
        int remainder=deviceSerialNumber.length()%56;
        this.setOneCount((remainder > 0) ? deviceSerialNumber.length()/56 + 1 :  deviceSerialNumber.length()/56);
        return this;
    }
}
