package com.tykj.dev.device.finalcheck.entity.vo;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * finalDetailVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/24 at 5:41 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "决算报告细节")
@ExcelTarget("FinalReport")
public class FinalDetailVo {

    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("型号")
    private String model;

    @ApiModelProperty("部件")
    private String type;

    @ApiModelProperty("纵向")
    private Integer vertical = 0;

    @ApiModelProperty("横向")
    private Integer horizontal = 0;

    @ApiModelProperty("委托")
    private Integer commission = 0;

    @ApiModelProperty("其他")
    private Integer other = 0;

    @ApiModelProperty("合计")
    private Integer total = 0;

    @ApiModelProperty("代管")
    private Integer hosting = 0;

    @ApiModelProperty("收到")
    private Integer received = 0;

    @ApiModelProperty("发出")
    private Integer sending = 0;

    @ApiModelProperty("报废")
    private Integer scrapped = 0;

    @ApiModelProperty("销毁")
    private Integer destory = 0;

    @ApiModelProperty("丢失")
    private Integer loss = 0;

    @ApiModelProperty("备注")
    private String remake = "";

}
