package com.tykj.dev.device.library.repository;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@SuppressWarnings("SqlResolve")
public interface DeviceLibraryDao extends JpaRepository<DeviceLibrary, Integer>, JpaSpecificationExecutor<DeviceLibrary> {

    List<DeviceLibrary> findAllByOwnUnit(String ownUnit);

    List<DeviceLibrary> findAllByIdIn(List<Integer> ids);

    List<DeviceLibrary> getAllByModel(String model);

    List<DeviceLibrary> getAllByOwnUnit(String unit);

    List<DeviceLibrary> getAllByTypeAndNameAndModel(Integer type, String name, String model);

    List<DeviceLibrary> findAllBySeqNumberIn(List<String> seqNumbers);

    List<DeviceLibrary> findAllBySeqNumberInAndOwnUnitIn(List<String> seqNumbers,List<String> unitNames);


    boolean existsAllBySeqNumberInAndLifeStatus(List<String> seqNumbers,Integer lifeStatus);

    /**
     * 根据装备型号与装备所在地(多个地区)查询装备数量
     *
     * @param model     装备型号
     * @param locations 装备所在地列表
     * @return 装备数量
     */
    int countByModelAndLocationUnitIn(String model, List<String> locations);

    /**
     * 根据装备型号与装备所在地(一个地区)查询装备数量
     *
     * @param model    装备型号
     * @param location 装备所在地
     * @return 装备数量
     */
    int countByModelAndLocationUnit(String model, String location);

    List<DeviceLibrary> getAllByPartParentId(Integer parentId);

    List<DeviceLibrary> getAllByPartParentIdAndIsPart(Integer parentId, Integer isPart);

    List<DeviceLibrary> getAllByRfidCardId(String rfidCardId);

    @Query(nativeQuery = true, value = "select * from device_library where id in :idList")
    List<DeviceLibrary> getDeviceLibraryEntitiesByIdIn(@Param("idList") List<Integer> idList);

    List<DeviceLibrary> getAllByRfidSurfaceId(String rfid);

    @Query("select o from DeviceLibrary o where o.ownUnit= :unitName and o.createTime >= :startTime and o.createTime <= :endTime")
    List<DeviceLibrary> findAllByUnitBetweenTime(String unitName, Date startTime, Date endTime);

    List<DeviceLibrary> getAllByPackingId(Integer packingId);

    List<DeviceLibrary> getAllBySeqNumber(String seq);

    boolean existsAllByPackingIdInAndOwnUnitIn(List<Integer> packingIds,List<String> unitNames);

    boolean existsBySeqNumber(String seq);

    Integer countAllByModelAndOwnUnitInAndLifeStatusNotIn(String model,List<String> unitNames,List<Integer> lifeStatus);

    Integer countAllByModelAndOwnUnitInAndLifeStatusIn(String model,List<String> unitNames,List<Integer> lifeStatus);

    Integer countAllByPackingIdInAndOwnUnitInAndLifeStatusIn(List<Integer> packingIds,List<String> unitNames,List<Integer> lifeStatus);

    Integer countAllBySeqNumberInAndOwnUnitInAndLifeStatusIn(List<String> seqNumbers,List<String> unitNames,List<Integer> lifeStatus);


    List<DeviceLibrary> findAllByPackingIdInAndOwnUnit(List<Integer> packingIds,String unitNames);

    List<DeviceLibrary> findAllByPackingIdInAndOwnUnitIn(List<Integer> packingIds,List<String> unitNames);

    List<DeviceLibrary> findAllByOwnUnitAndLocationUnitAndLifeStatus(String ownUnitName,String locationUnitName,Integer status);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus  ,o.updateTime=current_timestamp where o.id in :idList")
    int upDateLeftStatus(Integer lifeStatus,@Param("idList") List<Integer> idList);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus  ,o.updateTime=current_timestamp where o.seqNumber  in :seqNumbers")
    int upDateSeqNumbersLeftStatus(Integer lifeStatus,@Param("seqNumbers") List<String> seqNumbers);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.applyTaskId = :applyTaskId  ,o.updateTime=current_timestamp where o.seqNumber  in :seqNumbers")
    int upDateSeqNumbersApplyTaskId(Integer applyTaskId,@Param("seqNumbers") List<String> seqNumbers);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.lockStatus=:lock  ,o.updateTime=current_timestamp where o.id in :idList")
    int upDateLeftStatusAndLockStatus(Integer lifeStatus,Integer lock,@Param("idList") List<Integer> idList);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lockStatus=:lock  ,o.updateTime=current_timestamp where o.id in :idList")
    int upDateLockStatus(Integer lock,@Param("idList") List<Integer> idList);


    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.locationUnit = :unitName,o.ownUnit = :unitName ,o.lockStatus=:lock  ,o.updateTime=current_timestamp where o.id in :idList")
    int upDateLeftStatusAndUnitNameAndLockStatus(Integer lifeStatus,String unitName,Integer lock,@Param("idList") List<Integer> idList);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.locationUnit = :unitName,o.ownUnit = :unitName,o.lockStatus=:lock ,o.updateTime=current_timestamp where o.seqNumber in :seqNumbers")
    int upDateSeqNumbersLeftStatusAndUnitNameAndLockStatus(Integer lifeStatus,String unitName,Integer lock,@Param("seqNumbers") List<String> seqNumbers);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.ownUnit = :unitName ,o.locationUnit = :unitName  ,o.updateTime=current_timestamp where o.id in :idList")
    int upDateLeftStatusAndOwnUnitName(Integer lifeStatus,String unitName,@Param("idList") List<Integer> idList);

    List<DeviceLibrary> findAllByLifeStatus(Integer status);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.rfidSurfaceId = o.seqNumber  ,o.updateTime=current_timestamp where o.id in :idList")
    int upDateRfidSurfaceIdAsSeqNumber(@Param("idList") List<Integer> idList);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.name = :name ,o.updateTime=current_timestamp where o.packingId = :packingId")
    int upDateName(String name,Integer packingId);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.matchingRange = :matchingRange ,o.updateTime=current_timestamp where o.packingId = :packingId")
    int upDateMatchingRange(Integer matchingRange,Integer packingId);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus where o.id = :id")
    int batchUpdate(Integer lifeStatus,Integer id);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus where o.id in :ids")
    int batchUpdate2(Integer lifeStatus,List<Integer> ids);

    DeviceLibrary findBySeqNumber(String seqNumber);

    List<DeviceLibrary> findAllByPackingId(Integer packingIds);

    List<DeviceLibrary> findAllByPackingIdIn(List<Integer> packingIds);


    @Modifying
    @Query("update DeviceLibrary d set d.model = :newModel where d.model = :oldModel")
    int batchUpdateDevices(String oldModel,String newModel);

    List<DeviceLibrary> findAllByModel(String model);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary d set d.ownUnit = d.locationUnit ,d.lifeStatus = 2 where d.id in :deviceIds")
    int updateDevicesOwnUnit(@Param("deviceIds") List<Integer> deviceIds);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary d set d.ownUnit = :ownUnit,d.locationUnit = :ownUnit,d.lifeStatus = 2 where d.id in :deviceIds")
    int updateDevicesOwnUnit(@Param("ownUnit") String ownUnit,@Param("deviceIds") List<Integer> deviceIds);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.matchingRange = :matchingRange ,o.updateTime=current_timestamp where o.packingId = :packingId")
    int updateMatchingRange(Integer matchingRange,Integer packingId);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.matchingRange = :matchingRange ,o.updateTime=current_timestamp where o.id in :deviceIds")
    int updateMatchingRange2(Integer matchingRange,@Param("deviceIds") List<Integer> deviceIds);

    List<DeviceLibrary> findByModelAndIsPart(String model,Integer isPart);
}

