package com.tykj.dev.device.library.service;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.library.subject.vo.DeviceStatisticsVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
public interface DeviceLibraryService {

    /**
     * @param deviceLibraryEntity 添加装备
     */
    DeviceLibrary addEntity(DeviceLibrary deviceLibraryEntity);

    /**
     * @param deviceLibraries 异步上链
     */
    void sendHash(List<DeviceLibrary> deviceLibraries);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取装备分页
     */
    Page<DeviceLibrary> getPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取标签管理分页
     */
    List<DeviceLibrary> getTagPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     */
    List<DeviceLibrary> getCoreDevicePage(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取装备统计分页
     */
    List<DeviceStatisticsVo> getDeviceStatisticsPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable, Sort sort);
//    /**
//     * @param deviceLibrarySelectVo 装备查询vo
//     * @param pageable              获取装备统计分页
//     */
//    List<DeviceStatisticsVo> getDeviceStatisticsPageAndSort(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);
    /**
     * 获取所有存在的装备名称
     */
    List<String> getAllName();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取单位装备列表
     */
    List<DeviceLibrary> getList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取所有区域装备列表
     */
    List<DeviceLibrary> getAllList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 获取单位自查装备在库列表
     */
    List<DeviceLibrary> getCheckList();

    /**
     * 获取单位自查未在库装备列表
     */
    List<DeviceLibrary> getNotInStockList();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取可配发装备列表
     */
    List<DeviceLibrary> getAllotList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param id 入库单id
     *           根据入库单Id查询装备列表
     */
    List<DeviceLibrary> getListByBillId(Integer id);

    /**
     * @param deviceLibraryEntity 更新装备信息
     */
    DeviceLibrary update(DeviceLibrary deviceLibraryEntity);

    /**
     * @param id 装备主键Id
     *           通过id查询某件装备
     */
    DeviceLibrary getOne(Integer id);

    /**
     * @param id 装备主键id
     *           逻辑删除某件装备
     */
    void delete(Integer id);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              不以父子结构返回单位装备列表
     */
    List<DeviceLibrary> getListWithoutParent(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 查询拥有装备的所有单位
     */
    List<String> getAllUnit();

    /**
     * 查询在库所有装备的型号
     */
    List<String> getAllInLibraryModels();

    /**
     * 查询可清退装备
     */
    List<DeviceLibrary> getSendBackDevice(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 判断装备状态是否在库（若不是抛出303异常）
     */
    void isInStock(List<Integer> ids);

    /**
     * 判断装备状态是否待退役（若不是抛出303异常）
     */
    void isWaitRetired(List<Integer> ids);

    /**
     * 判断装备状态是否在库或待退役（若不是抛出303异常）
     */
    void isInStockOrWaitRetired(List<Integer> ids);


    /**
     * 判断装备状态是否丢失（若不是抛出303异常）
     * @param ids
     */
    void isNotLoss(List<Integer> ids);

    /**
     * 判断装备状态是否在库或维修中（若不是抛出303异常）
     */
    void isInStockOrRepairing(List<Integer> ids);

    void isFirstRepair(List<Integer> ids);

    int getDeviceCount();

    /**
     * 获取所有装备id map
     */
    Map<Integer,DeviceLibrary> getAllDeviceMap();

    /**
     * 获取所有装备序列号map
     */
    Map<String,DeviceLibrary> getAllDeviceSeqMap();

    /**
     * 根据单位 以及生命状态集合 查询设备数量
     */
    Integer countAllRepel(List<Integer> fieldingIds,List<String> unitNames,List<String> seqNums,List<Integer> lifeStatusList);

    List<DeviceLibrary> findAllBySeqNumber(List<String> seqNumbers);

    /**
     * 判断装备序列号中是否有不等于指定的leftStatus的装备
     * 有则返回303给前端提示
     */
    void judgeSeqNumbersInNotEqualLifeStatus(List<String> seqNumbers,Integer leftStatus);

    /**
     * 根据装备id集合查询出所有的装备
     */

    List<DeviceLibrary> getAllDevByDevIds(List<Integer> ids);

    /**
     * @param lifeStatus 更新装备生命信息
     */
    void updateLifeStatus(Integer lifeStatus,Integer id);

    /**
     * @param lifeStatus 更新装备生命信息
     */
    void updateLifeStatus2(Integer lifeStatus,List<Integer> ids);

    List<DeviceLibrary> findByIds(List<Integer> ids);

    /**
     * @param seqNumber 序列号
     */
    DeviceLibrary findBySeqNumber(String seqNumber);

//    /**
//     *
//     */
//    List<DeviceLibrary> findByIds2(List<Integer> ids);

    /**
     * 得到所有的装备
     */
    List<DeviceLibrary> getAllDeviceList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 通过列装id查询所有装备
     */
    List<DeviceLibrary> findAllByPackingId(Integer packingId);

    /**
     * 通过列装id查询所有装备
     */
//    List<DeviceLibrary> findAllByPackingId2(List<Integer> packingIds);

    Map<Integer,List<DeviceLibrary>> findAllByPackingId3();

    /**
     * 批量更新装备
     * @param
     * @param
     */
    void batchUpdateDevices(String oldModel,String newModel);
    /**
     * 通过型号查询装备
     */
    List<DeviceLibrary> findAllByModel(String model);

    /**
     * @param deviceIds 装备id
     */
    void updateDevicesOwnUnit(List<Integer> deviceIds);

    /**
     * @param
     */
    void updateLocalAndOwn(String localUnit,List<Integer> deviceIds);

    /**
     * 根据型号查询序列号 取最大值的Device对象
     */
    int getMaxSeqNumber(String model);

    List<String> getMaxPartSeqNumber(String model,Integer isPart);


    /**
     * 通过 packing 查询装备
     * @param packing 列装id
     * @return
     */
    List<DeviceLibrary> findDevicesByPacking(Integer packing);

    void updateMatchingRange(List<DeviceLibrary> libraries);

}
