package com.tykj.dev.device.library.task;

import com.tykj.dev.device.library.service.DeviceLibraryCacheService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainTask.java
 * @Description 培训定时任务 主要是 判断报名截止以及培训开始、培训结束
 * @createTime 2020年08月17日 23:20:00
 */
@Service
@Slf4j
public class DevideTask {
    @Autowired
    DeviceLibraryCacheService deviceLibraryCacheService;

    @Scheduled(cron = "30 * * * * ? ")
    private void signUpDeadline() {
        log.info("定时device更新缓存开始");
        deviceLibraryCacheService.deletAllDeviceLibraryList();
        deviceLibraryCacheService.getAllDeviceLibraryList();
        log.info("定时device更新缓存结束");
    }
}
