package com.tykj.dev.device.loss.service.impl;

import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.loss.entity.domain.DeviceLoss;
import com.tykj.dev.device.loss.entity.vo.DeviceLossVo;
import com.tykj.dev.device.loss.service.DeviceLossService;
import com.tykj.dev.device.loss.service.LossBillSelectService;
import com.tykj.dev.device.loss.util.StringUtils;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.misc.base.BeanHelper;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName LossBillSelectServiceImpl.java
 * @Description TODO
 * @createTime 2021年01月30日 16:42:00
 */
@Service
public class LossBillSelectServiceImpl implements LossBillSelectService {
    @Autowired
    TaskService taskService;
    @Autowired
    DeviceLossService deviceLossService;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Override
    public DeviceLoss findDeviceLoss(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        DeviceLoss deviceLoss=deviceLossService.findByDeviceLoss(taskBto.getBillId());
        deviceLoss.setDeviceLossVoList( deviceLibraryDao.findAllById(StringUtils.stringToList(deviceLoss.getDevIds()))
                .stream().map(this::toDeviceLossVo).collect(Collectors.toList()));
        deviceLoss.setFileRetList(FilesUtil.stringFileToList(deviceLoss.getLossFile()));
        return deviceLoss;
    }

    private DeviceLossVo toDeviceLossVo(DeviceLibrary deviceLibrary){
        ModelMapper mapper = BeanHelper.getUserMapper();
        DeviceLossVo deviceLossVo=  mapper.map(deviceLibrary, DeviceLossVo.class);
        deviceLossVo.setTypeName(deviceLibrary.setConfigName().getTypeName());
        return deviceLossVo;
    }
}
