package com.tykj.dev.misc.utils;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 * 分页工具类
 */
public class PageUtil {

    /**
     * @param page 当前页数，默认0为第一页
     * @param size 分页大小
     *             获取分页后每一页的分页信息
     */
    public static <T> Page<T> getPerPage(Integer page, Integer size, List<T> list, Pageable pageable) {
        //若List的size小于分页大小（只有一页）
        if (list.size() <= size&&page==0) {
            return new PageImpl<>(list, pageable, list.size());
        } else {
            //计算分了几页
            double d = Math.ceil(list.size() / size.doubleValue());
            int value = new Double(d).intValue();
            //当前页数超出了最大页数
            if (page >= value) {
                return new PageImpl<>(new ArrayList<>(),pageable,list.size());
            } else {
                //当前页的第一条记录的索引值
                int index = page * size;
                //当前页为最后一页
                if (page == value - 1) {
                    return new PageImpl<>(list.subList(index, list.size()), pageable, list.size());
                }
                return new PageImpl<>(list.subList(index, index + size), pageable, list.size());
            }
        }
    }

//    public static <T> List<Comparator<T>> getSortComparator(List<T> list, List<CustomOrder> customOrders){
//        if (customOrders!=null&&customOrders.size()>0){
//
//        }
//        else {
//            return new ArrayList<>();
//        }
//    }
}
