package com.tykj.dev.misc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 * @description 分隔组合字段工具栏
 */
public class StringSplitUtil {

    /**
     * @param s 需要分隔的字符串
     * @return 一串id的List
     */
    public static List<Integer> split(String s) {
        List<Integer> list = new ArrayList<>();
        if (s!=null&&s.length()>0) {
            //分隔开始的s标识符
            if (s.charAt(0) == 's') {
                s = s.substring(1);
            }
            //按分隔符x分隔
            String[] strings = s.split("x");
            //遍历获取id\
            if (strings.length > 0) {
                for (String str : strings) {
                    if (str.length() >= 2 && "1".equals(str.substring(str.length() - 1))) {
                        list.add(Integer.parseInt(str.substring(0, str.length() - 1)));
                    }
                }
            }
        }
        return list;
    }

    public static List<Integer> userIdSplit(String s) {
        List<Integer> list = new ArrayList<>();
        if (s != null) {
            //按分隔符x分隔
            String[] strings = s.split("x");
            //遍历获取id
            if (strings.length != 0) {
                for (String str : strings) {
                    if (str.length() > 0) {
                        if ("null".equals(str)){
                            list.add(-100);
                        }
                        else {
                            list.add(Integer.valueOf(str));
                        }
                    }
                }
            }
        }
        return list;
    }

    public static String idListToString(List<Integer> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        if (list != null && list.size() > 0) {
            list.forEach(integer -> {
                stringBuffer.append(integer);
                stringBuffer.append("x");
            });
        }
        return stringBuffer.toString();
    }

    public static List<Integer> taskIdSplit(String s) {
        List<Integer> list = new ArrayList<>();
        if (s != null) {
            //按分隔符.分隔
            String[] strings = s.split("\\.");
            //遍历获取id
            if (strings.length != 0) {
                for (String str : strings) {
                    if (str.length() > 0) {
                        list.add(Integer.valueOf(str));
                    }
                }
            }
        }
        return list;
    }

    public static String ListToString(List<Integer> idList){
        StringBuffer stringBuffer=new StringBuffer();
        idList.forEach(
                i->stringBuffer.append(",").append(i)
        );
        return stringBuffer.toString();
    }

    public static String stringListToString(List<String> stringList){
        StringBuffer stringBuffer=new StringBuffer();
        stringList.forEach(
                i->stringBuffer.append(",").append(i)
        );
        if (stringBuffer.length()>0) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    public static List<Integer> stringToList(String idStirng){
        if (idStirng!=null) {
            List<String> idStringList = Arrays.asList(idStirng.split(","));
            return idStringList.stream().filter(list2 -> !list2.equals("")).map(Integer::parseInt).collect(Collectors.toList());
        }else {
            return new ArrayList<>();
        }
    }
}
