package com.tykj.dev.device.packing.service;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.Script;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.packing.subject.vo.AllotSeqs;
import com.tykj.dev.device.packing.subject.vo.PackingLibrarySelectVo;
import com.tykj.dev.device.packing.subject.vo.SelectPack;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface PackingLibraryService{

    /**
     * @param packingLibraryEntity 添加列装
     */
    PackingLibrary addEntity(PackingLibrary packingLibraryEntity);

    /**
     * @param packingLibraries 列装异步上链
     */
    void sendHash(List<PackingLibrary> packingLibraries);

    /**
     * @param packingLibrarySelectVo 列装查询vo
     * @param pageable               获取列装库分页
     */
    Page<PackingLibrary> getPage(PackingLibrarySelectVo packingLibrarySelectVo, Pageable pageable);

    /**
     * @param packingLibrarySelectVo 列装查询vo
     * @param pageable               获取列装库退装分页
     */
    List<PackingLibrary> getInvalidPage(PackingLibrarySelectVo packingLibrarySelectVo, Pageable pageable);

    /**
     * @param packingLibrarySelectVo 列装查询vo
     *                               获取父子结构列装列表
     */
    List<PackingLibrary> getList(PackingLibrarySelectVo packingLibrarySelectVo);

    /**
     * @param packingLibrarySelectVo 列装查询vo
     *                               获取父子结构列装列表
     */
    List<PackingLibrary> getList1(PackingLibrarySelectVo packingLibrarySelectVo);

    /**
     * 获取所有存在的类型列表
     */
    List<Integer> getTypeList();

    /**
     * 获取所有的型号列表
     */
    List<String> getModelList();

    /**
     * @param id 列装库装备主键id
     *           获取某个列装装备的所有配件
     */
    List<PackingLibrary> selectAllPart(Integer id);

    /**
     * @param packingLibraryEntity 更新列装信息
     */
    PackingLibrary update(PackingLibrary packingLibraryEntity);

    /**
     * @param id 列装库主键Id
     *           根据id获取列装
     */
    PackingLibrary getOne(Integer id);

    /**
     * @param id 列装库装备主键id
     *           通过id查询列装详情(装备+配件)
     */
    List<PackingLibrary> getPackingDetail(Integer id);

    /**
     * @param id 列装库装备主键id
     *           通过id查询退装详情(装备+配件)
     */
    List<PackingLibrary> getInvalidDetail(Integer id);

    /**
     * @param id 列装主键id
     *           通过id逻辑删除列装
     */
    void delete(Integer id);

    /**
     * @param selectPack 列装查询vo
     * 获取父子结构列装列表
     */
    List<PackingLibrary> getInsertList(SelectPack selectPack);

    /**
     * @param id 列装主键id
     * 通过id退装该列装以及所有子列装
     */
    void deleteAll(Integer id);

    /**
     * @param ids 列装主键id列表
     * 通过id将退装装备恢复到列装
     */
    void removeAll(List<Integer> ids);

    /**
     * @param ids 列装主键id列表
     * 通过id将回收站装备清空删除
     */
    void cleanAll(List<Integer> ids);

    /**
     * 设置顺序的排序
     */
    List<PackingLibrary> setOrder(List<PackingLibrary> packingLibraries);

    List<Script> getDevcieScript(List<Integer> ids);

    List<Script> getDevcieAllotScript(List<Integer> ids);

    /**
     * @param packingId 列装id
     * @param num 配发数量
     * @return 自动选择装备生成的序列号区间
     * 配发按照序列号排序自动选择装备
     */
    AllotSeqs getAllotAutoSeqs(Integer packingId, Integer num);

    Integer getAllotNum(Integer packingId);

    List<PackingLibrary> setAllotNum(List<PackingLibrary> packingLibraries);

    List<DeviceLibrary> getAllDevSeqs(Integer packingId);

    List<DeviceLibrary> getAllotDevSeqs(Integer packingId);

    Boolean modelIsExist(String model);

    /**
     * @param id 列装主键id
     * 通过id修改该列装所有子列装型号
     */
    void changeAllModel(Integer id,String model);

    Boolean nameIsExist(String model,String name ,Integer partParentId);

    Boolean nameIsExist1(String model,String name ,Integer partParentId,Integer matchingRange);

    Boolean matchingRangeIsExist(Integer parentId,Integer matchingRange,Integer type,Integer style,String name,Integer secretLevel,Integer invisibleRange);


    /**
     * @param parentId 父列装id
     * @param matchingRange 配用范围
     * 查询对应横向或纵向列装
     */
    PackingLibrary findSamePacking(Integer parentId,Integer matchingRange,Integer type,Integer style,String name,Integer secretLevel,Integer invisibleRange);

    /**
     * 列装状态2 和4
     * @param parentId 父列装id
     * @param matchingRange 配用范围
     *
     * 查询对应横向或纵向列装
     */
    PackingLibrary findSamePackingInPackingStatus(Integer parentId,Integer matchingRange,Integer type,Integer style,String name,Integer secretLevel,Integer invisibleRange);

    /**
     *
     * @param parentId 父列装id
     * @param matchingRange 配用范围
     * @param type
     * @param style
     * @param name
     * @param secretLevel
     * @param invisibleRange
//     * @param del 删除标志
     * @return
     */
//    PackingLibrary findSamePackingByDel(Integer parentId,Integer matchingRange,Integer type,Integer style,String name,Integer secretLevel,Integer invisibleRange,Integer del,Integer status);


    List<PackingLibrary> findSamePacking1(Integer parentId,Integer matchingRange,Integer type,Integer style,String name,Integer secretLevel,Integer invisibleRange);
    /**
     * @param packingLibraries 父子结构列装
     * 拆分父子结构列装
     */
    List<PackingLibrary> splitTree(List<PackingLibrary> packingLibraries);

    /**
     * 判断是否有相同名称的列装装备，如果相同则可以进行新增
     */
    Boolean hasSamePack(Integer parentId,Integer type,Integer style,String name,Integer secretLevel,Integer invisibleRange);

    List<PackingLibrary> getAllByPartPackingId(Integer partPackingId);


    /**
     * @param packingLibraryEntity 添加配发使用
     */
    Boolean addAllotPacking(PackingLibrary packingLibraryEntity);

    /**
     * 查询所有的列装model的排序
     */
    void  getSortMap();

    /**
     * 根据父id查询
     */
    List<PackingLibrary> findByParentId(Integer parentId);
}
