package com.tykj.dev.device.packing.service.impl;

import com.tykj.dev.blockcha.subject.entity.BcHash;
import com.tykj.dev.blockcha.subject.service.BlockChainUtil;
import com.tykj.dev.config.TaskBeanConfig;
import com.tykj.dev.device.packing.repository.PackingLogDao;
import com.tykj.dev.device.packing.service.PackingLogService;
import com.tykj.dev.device.packing.subject.domin.PackingLog;
import com.tykj.dev.misc.utils.JacksonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.CompletableFuture;

@Service
public class PackingLogServiceImpl implements PackingLogService {
    @Autowired
    private PackingLogDao packingLogDao;

    @Autowired
    private BlockChainUtil blockChainUtil;

    @Override
    public void add(PackingLog packingLog) {
        PackingLog packingLog1 = packingLogDao.save(packingLog);
        CompletableFuture.runAsync(()->{
            PackingLog packingLog2 = packingLogDao.findById(packingLog1.getId()).get();
            BcHash bcText = blockChainUtil.sendHash(1000, JacksonUtil.toJSon(packingLog2));
            String recordId = bcText.getData().getRecordID();
            packingLog2.setRecordId(recordId);
            packingLogDao.save(packingLog2);
        }, TaskBeanConfig.getThreadPoolTaskScheduler());
    }
}
