package com.tykj.dev.device.policydocument.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.policydocument.entity.PolicyDocVo;
import com.tykj.dev.device.policydocument.entity.PolicyDocument;
import com.tykj.dev.device.policydocument.service.PolicyDocumentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryController.java
 * @Description TODO
 * @createTime 2021年01月10日 15:43:00
 */
@RestController
@Api(tags = "政策文件、软件模块", description = "政策文件、软件模块 用type区分 1.政策 2.软件")
@AutoDocument
@RequestMapping("/policyDoc")
public class PolicyDocController {

    @Autowired
    PolicyDocumentService policyDocumentService;


    /**
     * 添加政策文件
     */
    @ApiOperation(value = "添加政策文件")
    @PostMapping("/save")
    public ResponseEntity findOutsideTheProvince(@RequestBody PolicyDocument policyDocument) {
        return ResponseEntity.ok(policyDocumentService.save(policyDocument));
    }


    /**
     * 查询政策文件 -分页
     */
    @ApiOperation(value = "添加政策文件")
    @PostMapping("/findAll/page")
    public ResponseEntity findAllPage(@RequestBody PolicyDocVo policyDocument) {
        return ResponseEntity.ok(policyDocumentService.findAllPage(policyDocument));
    }


    /**
     * 删除政策文件
     */
    @ApiOperation(value = "删除政策文件")
    @GetMapping("/delete/{id}")
    public ResponseEntity deleteById( @PathVariable Integer id) {
        policyDocumentService.deleteById(id);
        return ResponseEntity.ok("删除成功");
    }


}
