package com.tykj.dev.device.policydocument.entity;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName PolicyDocument.java
 * @Description 政策文件信息
 * @createTime 2021年05月13日 10:59:00
 */
@Data
@Entity
@NoArgsConstructor
@AllArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@ApiModel("政策文件信息")
public class PolicyDocument extends BaseEntity {

    private String name;


    @Column(name = "file_string" ,columnDefinition = "TEXT")
    private String fileString;

    @Transient
    private List<FileRet> fileRetList;

    /**
     * 1 政策文件 2 软件
     */
    private Integer type;

    @Transient
    private String createUserName;
}
