package com.tykj.dev.device.questionbank.service;

import com.tykj.dev.device.questionbank.entity.Problem;
import com.tykj.dev.device.questionbank.entity.vo.ProblemPageVo;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

public interface ProblemService {
    /**
     * 添加题目
     */
    Problem saveProble(Problem problem);

    /**
     * 根据id查询题目
     */
    Problem findByIdProble(Integer id);


    /**
     * 根据类型、等级查询题目集合
     */
    List<Problem> findByTypeAndLevel(Integer type,Integer level);

    /**
     * 查询所有题目
     */
    List<Problem> findAll();

    /**
     * 根据id删除题目
     */
    void deleteById(Integer id);

    void deleteByIds(List<Integer> ids);

    Page<Problem> pageProblemSelect(ProblemPageVo problemPageVo);

    Map<Integer, Map<Integer,Integer>> getProblemCount();
}
