package com.tykj.dev.device.repair.repository;

import com.tykj.dev.device.repair.subject.domin.RepairBackBill;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepairBackBillDao.java
 * @Description TODO
 * @createTime 2020年08月25日 10:29:00
 */
public interface RepairBackBillDao extends JpaRepository<RepairBackBill, Integer>, JpaSpecificationExecutor<RepairBackBill> {
    RepairBackBill findByDeviceRepairBillId(Integer repairBillId);

    @Query("select o from RepairBackBill o where o.receiveUnit= :unitName and o.createTime >= :startTime and o.createTime <= :endTime")
    List<RepairBackBill> findAllByUnitBetweenTime(String unitName, Date startTime, Date endTime);
}

