package com.tykj.dev.device.repair.repository;

import com.tykj.dev.device.repair.subject.domin.RepairSendBill;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
public interface RepairSendBillDao extends JpaRepository<RepairSendBill, Integer>, JpaSpecificationExecutor<RepairSendBill> {
    RepairSendBill findByDeviceRepairBillId(Integer id);

    @Query("select o from RepairSendBill o where o.sendUnit= :unitName and o.createTime >= :startTime and o.createTime <= :endTime")
    List<RepairSendBill> findAllByUnitBetweenTime(String unitName, Date startTime, Date endTime);

//    @Transactional
//    @Modifying
//    @Query("update RepairSendBill r set r.scriptJson = :scriptJson where r.id in :repairDetailIds")
//    void updateRemakeForClear(@Param("scriptJson") String scriptJson, @Param("repairDetailIds") List<Integer> repairDetailIds);

}
