package com.tykj.dev.device.repair.service;

import com.tykj.dev.device.repair.subject.domin.RepairBill;
import com.tykj.dev.device.repair.subject.vo.RepairBillSelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface RepairBillService {

    RepairBill addEntity(RepairBill deviceRepairBillEntity);

    /**
     * @param repairBills 异步上链
     */
    void sendHash(List<RepairBill> repairBills);

    Page<RepairBill> getPage(RepairBillSelectVo deviceRepairBillSelectVo, Pageable pageable);

    RepairBill getOne(Integer id);

    RepairBill update(RepairBill deviceRepairBillEntity);

    void delete(Integer id);

    /**
     * 通过id集合进行查询
     */
    List<RepairBill> findByIds(List<Integer> ids);
}
