package com.tykj.dev.device.repair.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.repair.repository.HistoryRepairBillDao;
import com.tykj.dev.device.repair.service.HistoryPepairService;
import com.tykj.dev.device.repair.subject.domin.HistoryRepairBill;
import com.tykj.dev.device.repair.subject.vo.HistorySelectVo;
import com.tykj.dev.misc.utils.JacksonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HistoryPepairServiceImpl.java
 * @Description TODO
 * @createTime 2021年09月17日 08:43:00
 */
@Service
@Slf4j
public class HistoryPepairServiceImpl implements HistoryPepairService {
    @Autowired
    HistoryRepairBillDao historyRepairBillDao;


    @Override
    public void toDb() {
//


    }

    @Override
    public void toDb2() {
        try {
          List<String> list =  Files.readAllLines(Paths.get(ResourceUtils.getURL("classpath:").getPath()+"file.txt"));
          List<HistoryRepairBill> historyRepairBills = list
                  .stream()
                  .map(HistoryRepairBill::toDb)
                  .collect(Collectors.toList());
          historyRepairBills.forEach(
                  historyRepairBill -> {
                      historyRepairBillDao.save(historyRepairBill);
                  }
          );
        } catch (IOException e) {
            log.error("[toDb2] 找不到文件路径");
        }

    }

    @Override
    public Page<HistoryRepairBill> findByPageHistoryRepairBill(HistorySelectVo historySelectVo) {
        return historyRepairBillDao.findAll(getSpecificationHistoryRepairBill(historySelectVo),historySelectVo.getPageable()).map(historyRepairBill -> {
            historyRepairBill.setFileRetList(FilesUtil.stringFileToList(historyRepairBill.getFileRets()));
            return historyRepairBill;
        });
    }


    private Specification<HistoryRepairBill> getSpecificationHistoryRepairBill(HistorySelectVo historySelectVo) {
        PredicateBuilder<HistoryRepairBill> predicateBuilder = Specifications.and();
        if (historySelectVo.getDocNumDim() != null) {
            predicateBuilder.like("docNo","%"+historySelectVo.getDocNumDim()+"%" );
        }
        if (historySelectVo.getTimeDim() != null) {
            predicateBuilder.like("applyTime","%"+historySelectVo.getTimeDim()+"%");
        }
        return predicateBuilder.build();

    }


}
