package com.tykj.dev.device.repair.subject.domin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.repair.repairApp;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HistoryRepairBill.java
 * @Description TODO
 * @createTime 2021年09月16日 21:57:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("装备维修完成退回账单")
public class HistoryRepairBill {
    @Id
    @ApiModelProperty(name = "主键id")
    @JsonProperty("id")
    private Integer id;

    @JsonProperty("title")
    private String title;

    @JsonProperty("docNo")
    private String docNo;

    @JsonProperty("applyUnit")
    private String applyUnit;

    @JsonProperty("applyUser")
    private String applyUser;

    @JsonProperty("applyTime")
    private String applyTime;

    @JsonProperty("applyConfirmUser")
    private String applyConfirmUser;

    @JsonProperty("handleUnit")
    private String handleUnit;

    @JsonProperty("handleUser")
    private String handleUser;

    @JsonProperty("handleConfirmUser")
    private String handleConfirmUser;

    @JsonProperty("handleTime")
    private String handleTime;

    @JsonProperty("status")
    private Integer status;

    @JsonProperty("total")
    private Integer total;

    @JsonProperty("repairTotal")
    private String repairTotal;

    @JsonProperty("billFileid")
    private Integer billFileid;

    @JsonProperty("receiptNum")
    private String receiptNum;

    @JsonProperty("annex")
    private String annex;

    @JsonProperty("applyUnitName")
    private String applyUnitName;

    @JsonProperty("applyUserName")
    private String applyUserName;

    @JsonProperty("applyConfirmUserName")
    private String applyConfirmUserName;

    @JsonProperty("handleUnitName")
    private String handleUnitName;

    @JsonProperty("handleUserName")
    private String handleUserName;

    @JsonProperty("handleConfirmUserName")
    private String handleConfirmUserName;

    @JsonProperty("model")
    private String model;

    @JsonProperty("serNum")
    private Integer serNum;

    @JsonProperty("proNum")
    private Integer proNum;

    @JsonProperty("docNoLike")
    private String docNoLike;

    @JsonProperty("applyTimeFrom")
    private String applyTimeFrom;

    @JsonProperty("applyTimeTo")
    private Date applyTimeTo;

    @JsonProperty("fromMe")
    private String fromMe;

    @JsonProperty("toMe")
    private String toMe;

    @JsonProperty("isHandled")
    private String isHandled;

    @JsonProperty("isRecycle")
    private String isRecycle;

    @JsonProperty("comIds")
    private String comIds;

    @Column(name = "file_rets",columnDefinition = "text")
    private String fileRets;

    @Transient
    private List<FileRet> fileRetList;


    public String toDo(){
        return JacksonUtil.toJSon(this);
    }

    public static HistoryRepairBill toDb(String data){
        return JacksonUtil.readValue(data,HistoryRepairBill.class);
    }

}
