package com.tykj.dev.device.repair.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("维修单存储类")
public class RepairBillSaveVo {

    @NotNull(message = "startUseraId不能为空")
    @Min(value = 1,message = "startUseraId不能小于1")
    @ApiModelProperty(value = "发起申请人", example = "1")
    private Integer startUseraId;

//    @NotNull(message = "startUserbId不能为空")
//    @Min(value = 1,message = "startUserbId不能小于1")
    @ApiModelProperty(value = "发起确认人", example = "1")
    private Integer startUserbId;

    @NotNull(message = "receiveUnit不能为空")
    @ApiModelProperty(value = "维修单位", example = "市机要局")
    private String receiveUnit;

    @NotNull(message = "sendUnit不能为空")
    @ApiModelProperty(value = "发起单位", example = "市机要局")
    private String sendUnit;

    @ApiModelProperty(value = "维修经手人", example = "1")
    private Integer repairUseraId;

//    @NotNull(message = "applyNumber不能为空")
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

//    @NotNull(message = "replayNumber不能为空")
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "签发人")
    private String agent;

//    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "出库附件文件名")
    private String fileName;

//    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "出库附件文件地址URL")
    private String fileUrl;

    @ApiModelProperty(value = "维修经手人")
    private String repairUserA;

    @NotNull(message = "sendingCount不能为空")
    @Min(value = 1,message = "sendingCount不能小于1")
    @ApiModelProperty(value = "应出库装备数量")
    private Integer sendingCount;

    @NotNull(message = "sendedCount不能为空")
    @Min(value = 0,message = "sendedCount不能小于0")
    @ApiModelProperty(value = "已出库装备数量")
    private Integer sendedCount;

//    @NotNull(message = "repairDeviceCheckDetail不能为空")
    @ApiModelProperty(value = "送修装备出库详情(装备主键id+核对结果(0缺失1无误3新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增")
    private String repairDeviceCheckDetail;

//    @NotNull(message = "repairDeviceCheckResult不能为空")
    @ApiModelProperty(value = "送修装备出库检查结果")
    private String repairDeviceCheckResult;

    @Valid
    @NotEmpty(message = "deviceList不能为空")
    @ApiModelProperty(value = "维修装备详情列表")
    private List<DeviceDetailVo> deviceList;

    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务Id")
    private Integer taskId;

    @ApiModelProperty(value = "左签章Id")
    private String leftSignatureId;

    @ApiModelProperty(value = "发送方附件")
    private List<FileRet> sendFileList;

    @ApiModelProperty(value = "收件方附件")
    private List<FileRet> receiveFileList;

    @ApiModelProperty(value = "单据保存vo")
    private List<ScriptSaveVo> scriptSaveVos;

    @ApiModelProperty(value = "省直属")
    private List<FileRet> receiveFiles;
}
