package com.tykj.dev.device.repair.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备维修状态修改类")
public class RepairStatusChangeVo {

//    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(name = "业务id", value = "1")
    private Integer taskId;

    @NotEmpty(message = "id不能为空")
    @ApiModelProperty(name = "维修详情单主键Id列表")
    private List<Integer> id;

    @NotNull(message = "newStatus不能为空")
    @Min(value = 0,message = "newStatus不能小于0")
    @ApiModelProperty(name = "新的维修状态", value = "1")
    private Integer newStatus;

    @ApiModelProperty(name = "报废单文件名")
    private String fileName;

    @ApiModelProperty(name = "报废单URL")
    private String fileUrl;
}
