package com.tykj.dev.device.retired.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DeviceRetierResultVo
 * @packageName com.tykj.dev.device.retired.subject.entity.vo
 **/
@ApiModel("退装-列装详情")
@Data
public class DeviceRetiredResultVo {

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "id")
    private Integer partParentId;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "型号", example = "xxx-1")
    private String model;

    @ApiModelProperty(value = "经办人/主管领导", example = "密级")
    private Integer secretLevel;

    @ApiModelProperty(value = "类型", example = "1")
    private Integer type;

    @ApiModelProperty(value = "经办人/主管领导", example = "密级")
    private String secretLevelName;

    @ApiModelProperty(value = "类型", example = "1")
    private String typeName;

    @ApiModelProperty(value = "数量", example = "1")
    private Long count;

    private Integer isPart;

    @ApiModelProperty(value = "配用范围")
    private String matchingRangeName;

    @ApiModelProperty(value = "数量", example = "1")
    private List<DeviceRetiredResultVo> childs = new ArrayList<>();

    public boolean devNumIsZero(){
        if (this.count==0){
            if (this.childs.size()>0){
                for (DeviceRetiredResultVo d:this.childs) {
                    if (d.getCount()>0){
                        return false;
                    }
                    else if (!d.devNumIsZero()){
                        return false;
                    }
                }
                return true;
            }
            else {
                return true;
            }
        }
        else {
            return false;
        }
    }

    public void addChildNode(DeviceRetiredResultVo deviceRetiredResultVo) {
        childs.add(deviceRetiredResultVo);
    }
}
