package com.tykj.dev.device.scrap.repository;

import com.tykj.dev.device.scrap.subject.domin.ScrapBill;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
public interface ScrapBillDao extends JpaRepository<ScrapBill, Integer>, JpaSpecificationExecutor<ScrapBill> {

    @Query("select o from ScrapBill o where o.scrapUnit= :unitName and o.createTime >= :startTime and o.createTime <= :endTime")
    List<ScrapBill> findAllByUnitBetweenTime(String unitName, Date startTime, Date endTime);
}
