package com.tykj.dev.device.scrap.service;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.scrap.subject.domin.Scrap;
import com.tykj.dev.device.scrap.subject.vo.ScrapSelectVo;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ScrapQueryService.java
 * @Description TODO
 * @createTime 2021年03月31日 14:13:00
 */
public interface ScrapQueryService {
    Page<Scrap> findPageScrapList(ScrapSelectVo scrapSelectVo);

    /**
     * 根据taskId查询报废详情
     * @param taskId 任务id
     * @return 详情
     */
    Scrap findTaskId(Integer taskId);


    TaskBto findApplyIdToScrapTask(Integer applyId);

    /**
     * 根据taskId查询相关文件接口（设备日志使用）
     */
    Map<String, List<FileRet>> findByTaskIdToFileMapList(Integer taskId);
}
