package com.tykj.dev.device.selfcheck.service;


import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.device.selfcheck.subject.vo.SelfCheckSelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
public interface SelfCheckBillService {

    SelfCheckBill addEntity(SelfCheckBill selfExaminationBillEntity);

    /**
     * @param selfCheckBills 异步上链
     */
    void sendHash(List<SelfCheckBill> selfCheckBills);

    SelfCheckBill update(SelfCheckBill selfExaminationBillEntity);

    SelfCheckBill getOne(Integer id);

    Page<SelfCheckBill> getPage(SelfCheckSelectVo selfCheckSelectVo, Pageable pageable);

    void delete(Integer id);

    /**
     * 根据核查完成时间去查询当前单位系统发起的自查任务
     */
    List<SelfCheckBill> findByDate(Date date,String unitName);

    List<SelfCheckBill> findBySystem(String unitName);

    /**
     * 根据taskId查询单据
     * @param taskId
     * @return
     */
    Map<String,List<FileRet>> getFileList(Integer taskId);
}
