package com.tykj.dev.device.selfcheck.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("自查单保存类")
@Repository
public class SelfCheckSaveVo {

    @NotNull(message = "type不能为空")
    @ApiModelProperty(name = "自查方式（0：手动，1：扫码）", example = "1")
    private Integer type;

    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(name = "任务id", example = "1")
    private Integer taskId;

//    @NotNull(message = "userbId不能为空")
    @Min(value = 1,message = "userbId不能小于1")
    @ApiModelProperty(name = "审核人ID", example = "1")
    private Integer userbId;

    @NotNull(message = "checkingCount不能为空")
    @Min(value = 0,message = "checkingCount不能小于0")
    @ApiModelProperty(name = "应查数量", example = "1")
    private Integer checkingCount;

    @NotNull(message = "checkedCount不能为空")
    @Min(value = 0,message = "checkedCount不能小于0")
    @ApiModelProperty(name = "实查数量", example = "1")
    private Integer checkedCount;

    @NotNull(message = "checkResult不能为空")
    @ApiModelProperty(name = "自查结果", example = "通过")
    private String checkResult;

    @NotNull(message = "checkDetail不能为空")
    @ApiModelProperty(name = "自查详情", example = "10x21x", value = "自查详情(装备主键id+核对结果(0缺失1无误2新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增")
    private String checkDetail;

    @ApiModelProperty(name = "新增未记录装备RFID列表")
    private List<String> newDeviceList;

    @ApiModelProperty(value = "检查附件名")
    private List<FileRet> checkFiles;

    @ApiModelProperty(value = "非在库装备集合")
    private List<DeviceLibrary> unStockDevices;

    @ApiModelProperty(value = "手持终端信息")
    private String handheldTerminalInformation;

    public SelfCheckBill toDo() {
        SelfCheckBill selfExaminationBillEntity = new SelfCheckBill();
        BeanUtils.copyProperties(this, selfExaminationBillEntity);
        selfExaminationBillEntity.setCheckTime(new Date());
        selfExaminationBillEntity.setCheckStatus(0);
        if(this.checkFiles!=null&&this.checkFiles.size()>0){
            selfExaminationBillEntity.setCheckFiles(FilesUtil.stringFileToList(this.checkFiles));
        }
        if (this.unStockDevices!=null&&this.unStockDevices.size()>0){
            selfExaminationBillEntity.setUnStockDetail(JacksonUtil.toJSon(this.unStockDevices));
        }
        return selfExaminationBillEntity;
    }
}
