package com.tykj.dev.device.sendback.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.repair.service.HistoryPepairService;
import com.tykj.dev.device.repair.subject.vo.HistorySelectVo;
import com.tykj.dev.device.sendback.entity.vo.HistorySelectSendBillVo;
import com.tykj.dev.device.sendback.service.HistorySendBillService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HistoryPepairContriller.java
 * @Description TODO
 * @createTime 2021年09月17日 10:21:00
 */
@RestController
@RequestMapping(value = "/historySend")
@AutoDocument
@Api(tags = "历史1。退回 2。退役模块", description = "历史1。退回 2。退役模块")
public class HistorySendBillContriller {
    @Autowired
    HistorySendBillService historySendBillService;

    @ApiOperation(value = "采集文件")
    @GetMapping("/read")
    public ResponseEntity test(){
        historySendBillService.toDb();
        return ResponseEntity.ok("ok");
    }

    @ApiOperation(value = "转数据库")
    @GetMapping("/todb")
    public ResponseEntity toDb(){
        historySendBillService.toDb2();
        return ResponseEntity.ok("ok");
    }

    @ApiOperation(value = "历史数据查询接口")
    @PostMapping("/select/bill")
    public ResponseEntity findByPageHistoryRepairBill(@RequestBody HistorySelectSendBillVo historySelectSendBillVo){

        return ResponseEntity.ok(historySendBillService.findByPageHistoryRepairBill(historySelectSendBillVo));
    }
}
