package com.tykj.dev.device.sendback.entity.domain;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description
 * @createTime 2021年01月10日 10:34:00
 */
@Data
@Entity
@NoArgsConstructor
@AllArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@ApiModel("已清退装备信息")
public class RepelDeviceUnit {
    @Id
    @GeneratedValue
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    private Integer deviceId;

    private Integer unitsId;

    public RepelDeviceUnit(Integer deviceId, Integer unitsId) {
        this.deviceId = deviceId;
        this.unitsId = unitsId;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public  Integer getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getUnitsId() {
        return unitsId;
    }

    public void setUnitsId(Integer unitsId) {
        this.unitsId = unitsId;
    }
}
