package com.tykj.dev.device.sendback.entity.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.sendback.entity.domain.HistorySendBill;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.modelmapper.ModelMapper;

import javax.persistence.*;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HistorySendBill.java
 * @Description TODO
 * @createTime 2021年09月22日 13:23:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Slf4j
public class HistorySendBillVo {

    @ApiModelProperty(name = "主键id")
    @Excel(name = "ID", orderNum = "1", width = 30, needMerge = true)
    private Integer oid;

    @JsonProperty("docNo")
    @Excel(name = "单号", orderNum = "1", width = 30, needMerge = true)
    private String docNo;

    @JsonProperty("applyTime")
    @Excel(name = "发送时间", orderNum = "1", width = 30, needMerge = true)
    private String applyTime;

    @JsonProperty("handleTime")
    @Excel(name = "签收时间", orderNum = "1", width = 30, needMerge = true)
    private String handleTime;

    @JsonProperty("applyUnitName")
    @Excel(name = "发送单位", orderNum = "1", width = 30, needMerge = true)
    private String applyUnitName;

    @JsonProperty("applyUserName")
    @Excel(name = "发送经办人", orderNum = "1", width = 30, needMerge = true)
    private String applyUserName;

    @JsonProperty("applyConfirmUserName")
    @Excel(name = "发送签发", orderNum = "1", width = 30, needMerge = true)
    private String applyConfirmUserName;

    @JsonProperty("handleUnitName")
    @Excel(name = "接收单位", orderNum = "1", width = 30, needMerge = true)
    private String handleUnitName;

    @JsonProperty("handleUserName")
    @Excel(name = "签收", orderNum = "1", width = 30, needMerge = true)
    private String handleUserName;

    @JsonProperty("handleConfirmUserName")
    @Excel(name = "经办", orderNum = "1", width = 30, needMerge = true)
    private String handleConfirmUserName;

    @Excel(name = "发送单据", orderNum = "1", width = 30, needMerge = true)
    private Integer applyFileId;

    @Excel(name = "签收单据", orderNum = "1", width = 30, needMerge = true)
    private Integer handleFileId;

    @Transient
    private List<FileRet> fileRetSendList;

    @Transient
    private List<FileRet> fileRetHandleList;



    public HistorySendBill toHistorySendBillVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        HistorySendBill historySendBill= mapper.map(this, HistorySendBill.class);
        return historySendBill;
    }







}
