package com.tykj.dev.device.sendback.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <h4>Description : 统计省或各市待清退统计单的数量</h4>
 *
 * @Author czq
 * @Date 2020-08-15 17:26
 * @Version 1.0
 */
@Data
@ApiModel("统计省或各市待清退统计单的数量")
public class StatisticalVo {

    @ApiModelProperty(value = "装备名称")
    private String name = "";

    @ApiModelProperty(value = "所有装备的数量", example = "20")
    private Integer allCount = 0;

    @ApiModelProperty(value = "已清退装备的数量", example = "10")
    private Integer valCount = 0;

    @ApiModelProperty(value = "状态", example = "1")
    private Integer status = 3;

    @ApiModelProperty(value = "各市或各单位的id集合", example = "[1,2,3]")
    private List<Integer> deviceIdList = new ArrayList<>();


    public Integer status(Integer status) {
        /*
        判断是否可办结
         */
        int allStatus = 0;
        if (allCount != 0 && valCount == 0) {
            /*
            清退完成
             */
            this.status = 3;
            return 0;

        } else if (allCount != 0) {
            /*
            清退未完成
             */
            this.status = status;
            allStatus = 1;
        }
        return allStatus;

    }

}
