package com.tykj.dev.device.sendback.service;

import com.tykj.dev.device.sendback.entity.domain.DeviceRepel;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepelDetail;
import com.tykj.dev.device.sendback.entity.vo.OrderOutData;
import com.tykj.dev.device.sendback.entity.vo.RepelAuditResult;
import com.tykj.dev.device.sendback.entity.vo.ResolveConfirm;
import com.tykj.dev.device.sendback.entity.vo.StorageDeviceRepel;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import org.apache.poi.ss.formula.functions.T;

import java.util.List;


public interface RepelBusinessService {
    /**
     * 发起清退任务
     */
     void initiateRepel(DeviceRepel deviceRepel, Integer userId);

    /**
     * 市分解任务
     */
     void resolveRepel(DeviceRepel deviceRepel,Integer taskId,Integer userId);


    /**
     * 市发起清退任务
     */
    void cityInitiateRepel(DeviceRepel deviceRepel,Integer userId);


    /**
     * 省审核市清退任务
     */
    void provinceAuditCity(Integer taskId,Integer userId,RepelAuditResult repelAuditResult);


    /**
     * 1。市提交装备提交装备信息，省进行确认
     * 2。区县提交装备信息，市进行确认
     * 修改repeltask的状态
     * 以及修改账单的详情把装备写入到实体中
     */
     void resolveConfirm(Integer taskId,Integer userId);

    /**
     * 选择装备 与账单和task关联
     */
    void submitChooseDevice(Integer taskId, ResolveConfirm resolveConfirm);

    /**
     * 省市审核需要清退装备信息
     * 省：同意则 市走出库流程，把装备送到省
     * 市：同意则 区县出库流程，把装备送到市
     * 不同意 统一添加备注
     */
    void resolveAudit(Integer taskId, RepelAuditResult repelAuditResult);

    /**
     * 清退装备待出库 装备出库任务
     * 出库操作 上传出库单
     */
    DeviceRepelDetail sendBackOutCheck(Integer taskId, Integer userId, OrderOutData orderOutData);

    /**
     * 出库把任务推送至盖章审核
     */
    void sealOfAudit(Integer taskId,Integer userId,OrderOutData orderOutData);


    /**
     * 入库把任务推送至盖章审核
     */
    void sendSealOfAudit(Integer taskId,Integer userId, StorageDeviceRepel storageDeviceRepel);
    /**
     * 出库盖章审核调用
     * 通过出库
     * 不通过 退回状态
     */
    void outSealOfAuditEnd(Integer taskId,Integer reviewTheResults);

    /**
     * 入库盖章审核调用
     * 通过出库
     * 不通过 退回状态
     */
    void sendSealOfAuditEnd(Integer taskId,Integer reviewTheResults);

    /**
     * 上级清退装备入库
     */
    void storageDeviceRepel(Integer taskId, StorageDeviceRepel storageDeviceRepel);


    /**
     * 本级装备待清退提交 （需要根据主业务的type 给涉及的装备装备给不同的状态）
     */
    void oneselfRepel(Integer taskId,StorageDeviceRepel storageDeviceRepel,Integer userId);


    /**
     * 省直属任务等待上传 （需要根据主业务的type 给涉及的装备装备给不同的状态）
     */
    void provinceDirectlyUnder(Integer taskId, SecurityUser securityUser);

    /**
     * 省\市清退任待办结 签字上传
     */
    void provinceRepel(Integer taskId);

    /**
     * 市清退任待办结 需要打印清退清单 签字上传
     */
    void cityRepelEnd(Integer taskId);


    /**
     * 出库等待上传回执单 （需要根据主业务的type 给涉及的装备装备给不同的状态）
     */
    void receipts(StorageDeviceRepel storageDeviceRepel);

    /**
     * 添加发件签发人员信息
     */
    void addSendBUser(StorageDeviceRepel storageDeviceRepel);

    /**
     * 省直接从在库到待退役
     * 装备装备 在库-》待退役
     */
    void directlyRetired(List<Integer> ids);

    /**
     * 全部清退无装备提交调用接口
     *  完成清退任务 修改清退统计表中的这条任务的状态
     *  任务直接结束
     */
    void AllRepelNotDeviceSubmit(SecurityUser securityUser,Integer taskId);

    /**
     * 撤回任务
     * 根据任务id找到对应的任务 因为只有回执单时才有 回执单任务为只任务，主要配发任务为当前任务的主任务
     * 子任务 封存 主任务根据单位进行回退到不同的状态  市 -1206 区 -1205 装备统一变程在库状态
     */
    void withdraw(Integer taskId);


    /**
     * 清退总任务 撤销
     * 判断下面任务是否存在配发中的 有则不能撤回需要等配发结束后在撤回。
     */
    List<TaskBto>  repelWithdraw(Integer taskId);
}
